/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot;

import java.util.Optional;
import javax.servlet.Servlet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.register.route.MetadataRouter;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.boot.ObjectMapperConstructor;
import net.n2oapp.framework.config.compile.pipeline.N2oPipelineSupport;
import net.n2oapp.framework.mvc.cache.ClientCacheTemplate;
import net.n2oapp.framework.mvc.cache.LifetimeClientCacheTemplate;
import net.n2oapp.framework.ui.controller.DataController;
import net.n2oapp.framework.ui.servlet.AppConfigJsonWriter;
import net.n2oapp.framework.ui.servlet.AppConfigServlet;
import net.n2oapp.framework.ui.servlet.ExposedResourceBundleMessageSource;
import net.n2oapp.framework.ui.servlet.ModifiedClientCacheTemplate;
import net.n2oapp.framework.ui.servlet.data.DataServlet;
import net.n2oapp.framework.ui.servlet.page.PageServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
public class N2oServletConfiguration {
    @Value(value="${n2o.application.id:}")
    private String applicationId;
    @Value(value="${n2o.api.url:/n2o}")
    private String n2oApiUrl;

    @Bean
    @ConditionalOnProperty(name={"n2o.ui.cache.page.enabled"}, havingValue="true")
    public ClientCacheTemplate pageClientCacheTemplate(CacheManager cacheManager, Environment env) {
        String mode;
        boolean enabled = (Boolean)env.getProperty("n2o.ui.cache.page.enabled", Boolean.class, (Object)false);
        if (!enabled) {
            return null;
        }
        long lifetime = (Long)env.getProperty("n2o.ui.cache.page.lifetime", Long.class, (Object)600000L);
        switch (mode = (String)env.getProperty("n2o.ui.cache.page.mode", String.class, (Object)"lifetime")) {
            case "lifetime": {
                return new LifetimeClientCacheTemplate(lifetime);
            }
            case "modified": {
                return new ModifiedClientCacheTemplate(cacheManager);
            }
        }
        throw new UnsupportedOperationException("Unknown page client cache mode " + mode);
    }

    @Bean
    public ServletRegistrationBean pageServlet(MetadataEnvironment env, MetadataRouter router, AlertMessageBuilder messageBuilder, SubModelsProcessor subModelsProcessor, Optional<ClientCacheTemplate> pageClientCacheTemplate) {
        PageServlet pageServlet = new PageServlet();
        ReadCompileBindTerminalPipeline pipeline = (ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)N2oPipelineSupport.readPipeline((MetadataEnvironment)env).read()).transform()).validate()).cache()).copy()).compile()).transform()).cache()).copy()).bind();
        pageServlet.setPipeline(pipeline);
        pageServlet.setRouter(router);
        pageServlet.setObjectMapper(ObjectMapperConstructor.metaObjectMapper());
        pageServlet.setMessageBuilder(messageBuilder);
        pageServlet.setSubModelsProcessor(subModelsProcessor);
        pageServlet.setPropertyResolver(env.getSystemProperties());
        pageClientCacheTemplate.ifPresent(arg_0 -> ((PageServlet)pageServlet).setClientCacheTemplate(arg_0));
        return new ServletRegistrationBean((Servlet)pageServlet, new String[]{this.n2oApiUrl + "/page/*"});
    }

    @Bean
    public ServletRegistrationBean dataServlet(DataController controller, AlertMessageBuilder messageBuilder) {
        DataServlet dataServlet = new DataServlet(controller);
        dataServlet.setObjectMapper(ObjectMapperConstructor.metaObjectMapper());
        dataServlet.setMessageBuilder(messageBuilder);
        return new ServletRegistrationBean((Servlet)dataServlet, new String[]{this.n2oApiUrl + "/data/*"});
    }

    @Bean
    public ServletRegistrationBean appConfigServlet(ConfigurableEnvironment configurableEnvironment, ContextProcessor contextProcessor, ExposedResourceBundleMessageSource clientMessageSource, MetadataEnvironment env) {
        AppConfigJsonWriter writer = new AppConfigJsonWriter();
        writer.setContextProcessor(contextProcessor);
        writer.setPropertyResolver((PropertyResolver)configurableEnvironment);
        writer.setObjectMapper(ObjectMapperConstructor.metaObjectMapper());
        writer.setPath("classpath*:META-INF/config.json");
        writer.setOverridePath("classpath*:META-INF/config-build.json");
        AppConfigServlet appConfigServlet = new AppConfigServlet();
        appConfigServlet.setAppConfigJsonWriter(writer);
        appConfigServlet.setMessageSource(clientMessageSource);
        appConfigServlet.setEnvironment(env);
        ReadCompileBindTerminalPipeline pipeline = (ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)N2oPipelineSupport.readPipeline((MetadataEnvironment)env).read()).transform()).validate()).cache()).copy()).compile()).transform()).cache()).copy()).bind();
        appConfigServlet.setPipeline(pipeline);
        appConfigServlet.setApplicationSourceId(this.applicationId);
        return new ServletRegistrationBean((Servlet)appConfigServlet, new String[]{this.n2oApiUrl + "/config", "/n2o/config.json"});
    }
}

