/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.camunda;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.framework.boot.camunda.CamundaProxyEngine;
import net.n2oapp.framework.boot.camunda.ExtTask;
import net.n2oapp.framework.boot.camunda.ExtTaskImpl;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class EmbeddedCamundaProxyEngine
implements CamundaProxyEngine {
    @Autowired
    private ProcessEngine processEngine;

    @Override
    public Long getCountTasks(Map<String, Object> inParams) {
        TaskQuery taskQuery = this.processEngine.getTaskService().createTaskQuery();
        Collection filters = this.getValue(inParams, "filters", null);
        Collection variableNames = this.getValue(inParams, "select", null);
        if (filters != null) {
            filters.forEach(filter -> this.createFilter(taskQuery, (String)filter, variableNames, inParams));
        }
        return taskQuery.count();
    }

    @Override
    public List<ExtTask> findTasks(Map<String, Object> inParams) {
        TaskQuery taskQuery = this.processEngine.getTaskService().createTaskQuery();
        Collection filters = this.getValue(inParams, "filters", null);
        Collection variableNames = this.getValue(inParams, "select", null);
        if (filters != null) {
            filters.forEach(filter -> this.createFilter(taskQuery, (String)filter, variableNames, inParams));
        }
        Integer limit = this.getValue(inParams, "limit", 10);
        Integer page = this.getValue(inParams, "page", 1);
        List list = taskQuery.listPage((page - 1) * limit, limit.intValue());
        return list.stream().map(t -> this.map((Task)t, variableNames == null || variableNames.isEmpty() ? null : this.processEngine.getTaskService().getVariables(t.getId(), variableNames))).collect(Collectors.toList());
    }

    @Override
    public ExtTask getTask(String id) {
        Task task = (Task)this.processEngine.getTaskService().createTaskQuery().taskId(id).singleResult();
        return this.map(task, this.processEngine.getTaskService().getVariables(task.getId()));
    }

    @Override
    public void setTaskVariables(String taskId, Map<String, Object> variables) {
        this.processEngine.getTaskService().setVariables(taskId, variables);
    }

    @Override
    public void completeTask(String taskId, Map<String, Object> variables) {
        this.processEngine.getTaskService().complete(taskId, variables);
    }

    @Override
    public String startProcess(String processKey, Map<String, Object> variables) {
        ProcessInstance process = this.processEngine.getRuntimeService().startProcessInstanceByKey(processKey, variables);
        return process.getId();
    }

    private ExtTaskImpl map(Task task, Map<String, Object> variables) {
        ExtTaskImpl result = new ExtTaskImpl();
        result.setId(task.getId());
        result.setName(task.getName());
        result.setPriority(task.getPriority());
        result.setOwner(task.getOwner());
        result.setAssignee(task.getAssignee());
        result.setProcessInstanceId(task.getProcessInstanceId());
        result.setExecutionId(task.getExecutionId());
        result.setProcessDefinitionId(task.getProcessDefinitionId());
        result.setCreateTime(task.getCreateTime());
        result.setTaskDefinitionKey(task.getTaskDefinitionKey());
        result.setDueDate(task.getDueDate());
        result.setFollowUpDate(task.getFollowUpDate());
        result.setVariables(variables);
        return result;
    }

    private <T> T getValue(Map<String, Object> inParams, String name, T def) {
        Object val = inParams.get(name);
        return (T)(val == null ? def : val);
    }

    private void createFilter(TaskQuery taskQuery, String filter, Collection<String> variableNames, Map<String, Object> inParams) {
        Object value = inParams.get(filter);
        if (value == null) {
            return;
        }
        switch (filter) {
            case "id": 
            case "taskId": {
                taskQuery.taskId((String)value);
                break;
            }
            case "processInstanceId": {
                taskQuery.processInstanceId((String)value);
                break;
            }
            case "processInstanceBusinessKey": {
                taskQuery.processInstanceBusinessKey((String)value);
                break;
            }
            case "processDefinitionId": {
                taskQuery.processDefinitionId((String)value);
                break;
            }
            case "processDefinitionKey": {
                taskQuery.processDefinitionKey((String)value);
                break;
            }
            case "processDefinitionName": {
                taskQuery.processDefinitionName((String)value);
                break;
            }
            case "executionId": {
                taskQuery.executionId((String)value);
                break;
            }
            case "assignee": {
                taskQuery.taskAssignee((String)value);
                break;
            }
            case "owner": {
                taskQuery.taskOwner((String)value);
                break;
            }
            case "candidateGroup": {
                taskQuery.taskCandidateGroup((String)value);
                break;
            }
            case "candidateUser": {
                taskQuery.taskCandidateUser((String)value);
                break;
            }
            case "assigned": {
                if (Boolean.TRUE.equals(value)) {
                    taskQuery.taskAssigned();
                    break;
                }
                taskQuery.taskUnassigned();
                break;
            }
            case "unassigned": {
                if (Boolean.TRUE.equals(value)) {
                    taskQuery.taskUnassigned();
                    break;
                }
                taskQuery.taskAssigned();
                break;
            }
            case "taskDefinitionKey": {
                taskQuery.taskDefinitionKey((String)value);
                break;
            }
            case "name": {
                taskQuery.taskName((String)value);
                break;
            }
            case "priority": {
                taskQuery.taskPriority((Integer)value);
                break;
            }
            case "dueDate": {
                taskQuery.dueDate((Date)value);
                break;
            }
            case "createdOn": {
                taskQuery.taskCreatedOn((Date)value);
                break;
            }
            case "active": {
                if (!Boolean.TRUE.equals(value)) break;
                taskQuery.active();
                break;
            }
            case "suspended": {
                if (!Boolean.TRUE.equals(value)) break;
                taskQuery.suspended();
                break;
            }
            case "parentTaskId": {
                taskQuery.taskParentTaskId((String)value);
                break;
            }
            default: {
                if (!variableNames.contains(filter)) break;
                taskQuery.processVariableValueEquals(filter, value);
            }
        }
    }
}

