/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.route.jdbc;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.register.route.RouteInfoKey;
import net.n2oapp.framework.config.register.ConfigRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.SerializationUtils;

public class JDBCRouteRepository
implements ConfigRepository<RouteInfoKey, CompileContext> {
    private static final Logger logger = LoggerFactory.getLogger(JDBCRouteRepository.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${n2o.config.register.jdbc.table-name:route_repository}")
    private String tableName;
    @Value(value="${n2o.config.register.jdbc.create-table:false}")
    private Boolean createTable;

    public CompileContext save(RouteInfoKey key, CompileContext value) {
        String insertSQL = "INSERT INTO " + this.tableName + " VALUES (?, ?, ?, ?)";
        String updateSQL = "UPDATE " + this.tableName + " SET context=? WHERE url=? AND class=?";
        byte[] serialValue = SerializationUtils.serialize((Object)value);
        int cnt = this.jdbcTemplate.update(updateSQL, new Object[]{serialValue, key.getUrlMatching(), key.getCompiledClass().getName()});
        if (cnt < 1) {
            this.jdbcTemplate.update(insertSQL, new Object[]{UUID.randomUUID().toString(), key.getUrlMatching(), key.getCompiledClass().getName(), serialValue});
            logger.info(String.format("Inserted route: '%s' to [%s]", value, key.getUrlMatching()));
        } else {
            logger.info(String.format("Updated route: '%s' to [%s]", value, key.getUrlMatching()));
        }
        return value;
    }

    public void clearAll() {
        String deleteSQL = "DELETE FROM " + this.tableName;
        this.jdbcTemplate.update(deleteSQL);
    }

    public Map<RouteInfoKey, CompileContext> getAll() {
        String selectSQL = "SELECT url, class, context FROM " + this.tableName;
        List resultSet = this.jdbcTemplate.queryForList(selectSQL);
        Map<RouteInfoKey, CompileContext> result = resultSet.stream().collect(Collectors.toMap(this::getKey, row -> (CompileContext)SerializationUtils.deserialize((byte[])((byte[])row.get("context"))), (a, b) -> b));
        logger.info(String.format("Returned %s routes.", result.size()));
        return result;
    }

    @PostConstruct
    public void createTable() {
        if (this.createTable.booleanValue()) {
            String createTableSQL = "CREATE TABLE IF NOT EXISTS " + this.tableName + " (id uuid PRIMARY KEY, url char(255), class char(255), context binary)";
            this.jdbcTemplate.execute(createTableSQL);
            logger.info(String.format("Created table %s.", this.tableName));
        }
    }

    private RouteInfoKey getKey(Map<String, Object> map) {
        try {
            Class<Compiled> clazz = Class.forName("" + map.get("class")).asSubclass(Compiled.class);
            return new RouteInfoKey("" + map.get("url"), clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

