/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.route.jdbc;

import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.register.route.RouteInfoKey;
import net.n2oapp.framework.boot.route.jdbc.JDBCRouteRepository;
import net.n2oapp.framework.config.register.ConfigRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisRouteRepository
implements ConfigRepository<RouteInfoKey, CompileContext> {
    private static final Logger logger = LoggerFactory.getLogger(JDBCRouteRepository.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Value(value="${n2o.config.register.redis.key:routes}")
    private String HASH_KEY;
    private HashOperations<String, String, CompileContext> hashOperations;

    @PostConstruct
    private void init() {
        this.hashOperations = this.redisTemplate.opsForHash();
    }

    public CompileContext save(RouteInfoKey key, CompileContext value) {
        CompileContext contextInHash = (CompileContext)this.hashOperations.get((Object)this.HASH_KEY, (Object)key.getUrlMatching());
        this.hashOperations.put((Object)this.HASH_KEY, (Object)key.getUrlMatching(), (Object)value);
        String action = contextInHash == null ? "Inserted" : "Updated";
        logger.info(String.format("%s route: '%s' to [%s]", action, value, key.getUrlMatching()));
        return value;
    }

    public Map<RouteInfoKey, CompileContext> getAll() {
        Map<RouteInfoKey, CompileContext> result = this.hashOperations.entries((Object)this.HASH_KEY).entrySet().stream().collect(Collectors.toMap(row -> new RouteInfoKey((String)row.getKey(), ((CompileContext)row.getValue()).getCompiledClass()), Map.Entry::getValue, (a, b) -> b));
        logger.info(String.format("Returned %s routes.", result.size()));
        return result;
    }

    public void clearAll() {
        this.redisTemplate.delete((Object)this.HASH_KEY);
    }
}

