/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.sql;

import java.util.Collection;
import net.n2oapp.criteria.api.ComputationalCollectionPage;
import net.n2oapp.routing.datasource.JndiRoutingDataSourceTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class TransactionalQueryPage<T>
extends ComputationalCollectionPage<T> {
    private JndiRoutingDataSourceTemplate jndiRoutingDataSourceTemplate;
    private String dataSource;
    private ComputationalCollectionPage<T> queryPage;

    public TransactionalQueryPage(ComputationalCollectionPage<T> queryPage, JndiRoutingDataSourceTemplate template, String dataSource) {
        super(queryPage.getCriteria());
        this.queryPage = queryPage;
        this.jndiRoutingDataSourceTemplate = template;
        this.dataSource = dataSource;
    }

    public void init() {
        this.jndiRoutingDataSourceTemplate.execute(this.dataSource, (TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                TransactionalQueryPage.super.init();
            }
        });
    }

    public int getCount() {
        return (Integer)this.jndiRoutingDataSourceTemplate.execute(this.dataSource, transactionStatus -> TransactionalQueryPage.super.getCount());
    }

    public Collection<T> getCollectionInitial() {
        return this.queryPage.getCollectionInitial();
    }

    public int getCountInitial() {
        return this.queryPage.getCountInitial();
    }

    public Collection<Integer> getIdsInitial() {
        return this.queryPage.getIdsInitial();
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }
}

