/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.application;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.api.metadata.application.SidebarState;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Menu;
import net.n2oapp.framework.autotest.api.component.application.Sidebar;
import net.n2oapp.framework.autotest.impl.collection.N2oMenu;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oSidebar
extends N2oComponent
implements Sidebar {
    public N2oSidebar(SelenideElement element) {
        this.setElement(element);
    }

    @Override
    public void brandNameShouldBe(String brandName) {
        this.element().$$(".navbar-brand").filterBy(Condition.not((Condition)Condition.cssClass((String)"n2o-brand"))).get(0).shouldHave(new Condition[]{Condition.text((String)brandName)});
    }

    @Override
    public void brandLogoShouldBe(String logo) {
        this.element().$(".n2o-brand__image").shouldHave(new Condition[]{Condition.attributeMatching((String)"src", (String)(".*" + logo))});
    }

    @Override
    public void shouldBeFixed() {
        this.element().parent().shouldHave(new Condition[]{Condition.cssClass((String)"n2o-layout-fixed")});
    }

    @Override
    public void shouldBeRight() {
        this.element().parent().shouldHave(new Condition[]{Condition.cssClass((String)"flex-row-reverse")});
    }

    @Override
    public void shouldBeOverlay() {
        this.element().shouldHave(new Condition[]{Condition.cssClass((String)"n2o-sidebar-overlay")});
    }

    @Override
    public void shouldHaveState(SidebarState state) {
        this.element().shouldHave(new Condition[]{Condition.cssClass((String)state.name())});
    }

    @Override
    public void clickToggleBtn() {
        this.element().$(".n2o-sidebar__toggler").click();
    }

    @Override
    public Menu nav() {
        return N2oSelenide.collection(this.element().$$("nav"), N2oMenu.class);
    }

    @Override
    public Menu extra() {
        return N2oSelenide.collection(this.element().$$(".navbar-collapse .navbar-nav").get(1).$$("ul > li"), N2oMenu.class);
    }
}

