/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.cell;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ImageShape;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.ImageStatusElement;
import net.n2oapp.framework.api.metadata.meta.control.TextPosition;
import net.n2oapp.framework.autotest.api.component.cell.ImageCell;
import net.n2oapp.framework.autotest.impl.component.cell.N2oCell;

public class N2oImageCell
extends N2oCell
implements ImageCell {
    @Override
    public void srcShouldBe(String src) {
        this.img().shouldBe(new Condition[]{Condition.attribute((String)"src", (String)src)});
    }

    @Override
    public void imageShouldBe(String url) {
        this.img().shouldHave(new Condition[]{Condition.attribute((String)"src", (String)url)});
    }

    @Override
    public void widthShouldBe(int width) {
        this.img().parent().shouldHave(new Condition[]{Condition.attributeMatching((String)"style", (String)(".*max-width: " + width + "px;.*"))});
    }

    @Override
    public void shapeShouldBe(ImageShape shape) {
        switch (shape) {
            case circle: {
                this.imgShouldHaveCircleShape();
                break;
            }
            case rounded: {
                this.imgShouldHaveRoundedShape();
                break;
            }
            case square: {
                this.imgShouldHaveSquareShape();
            }
        }
    }

    @Override
    public void shouldHaveTitle(String title) {
        this.element().$(".n2o-image__info .n2o-image__info_label").shouldBe(new Condition[]{Condition.text((String)title)});
    }

    @Override
    public void shouldHaveDescription(String description) {
        this.element().$(".n2o-image__info .n2o-image__info_description").shouldBe(new Condition[]{Condition.text((String)description)});
    }

    @Override
    public void shouldHaveTextPosition(TextPosition textPosition) {
        this.element().$(".n2o-image__content").shouldBe(new Condition[]{Condition.cssClass((String)textPosition.name())});
    }

    @Override
    public void shouldHaveStatus(ImageStatusElement.Place position, int index, String title) {
        this.getStatus(position, index).$(".n2o-status__text").shouldBe(new Condition[]{Condition.text((String)title)});
    }

    private SelenideElement getStatus(ImageStatusElement.Place position, int index) {
        return this.element().$$(".n2o-image-statuses ." + position).get(index);
    }

    @Override
    public void statusShouldHaveIcon(ImageStatusElement.Place position, int index, String icon) {
        if (icon != null && !icon.isEmpty()) {
            this.element().$(".n2o-image-statuses ." + position).$(".n2o-status__icon" + icon).should(new Condition[]{Condition.exist});
        }
    }

    private void imgShouldHaveCircleShape() {
        this.img().parent().shouldHave(new Condition[]{Condition.cssClass((String)"circle")});
    }

    private void imgShouldHaveRoundedShape() {
        this.img().parent().shouldHave(new Condition[]{Condition.cssClass((String)"rounded")});
    }

    private void imgShouldHaveSquareShape() {
        this.img().parent().shouldNotHave(new Condition[]{Condition.cssClass((String)"circle")});
        this.img().parent().shouldNotHave(new Condition[]{Condition.cssClass((String)"rounded")});
    }

    private SelenideElement img() {
        return this.element().$("img");
    }
}

