/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.control.DateInput;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oDateInput
extends N2oControl
implements DateInput {
    @Override
    public void shouldBeEmpty() {
        SelenideElement elm = this.inputElement();
        if (elm.exists()) {
            elm.shouldBe(new Condition[]{Condition.empty});
        } else {
            this.cellInputElement().shouldBe(new Condition[]{Condition.empty});
        }
    }

    @Override
    public void shouldHaveValue(String value) {
        SelenideElement elm = this.inputElement();
        if (elm.exists()) {
            elm.shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.value((String)value)});
        } else {
            this.cellInputElement().shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.text((String)value)});
        }
    }

    @Override
    public String val() {
        SelenideElement elm = this.inputElement();
        return elm.exists() ? elm.val() : this.cellInputElement().text();
    }

    @Override
    public void val(String value) {
        this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
        if (this.element().is(Condition.cssClass((String)"n2o-editable-cell"))) {
            this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.ENTER})});
        } else {
            this.element().click();
        }
    }

    @Override
    public void timeVal(String hours, String minutes, String seconds) {
        this.element().$(".n2o-calendar-time-container").click();
        this.element().$$(".n2o-pop-up .hour-picker .n2o-calendar-time-unit").find(Condition.text((String)hours)).click();
        this.element().$$(".n2o-pop-up .minute-picker .n2o-calendar-time-unit").find(Condition.text((String)minutes)).click();
        this.element().$$(".n2o-pop-up .second-picker .n2o-calendar-time-unit").find(Condition.text((String)seconds)).click();
        this.element().$$(".n2o-calendar-time-buttons button").find(Condition.text((String)"\u0412\u044b\u0431\u0440\u0430\u0442\u044c")).click();
    }

    @Override
    public void shouldBeDisabled() {
        this.inputElement().shouldBe(new Condition[]{Condition.disabled});
    }

    @Override
    public void clickCalendarButton() {
        this.element().$(".btn.n2o-calendar-button").click();
    }

    @Override
    public void shouldBeActiveDay(String day) {
        this.element().$(".n2o-calendar-day.selected").shouldBe(new Condition[]{Condition.exist}).shouldHave(new Condition[]{Condition.text((String)day)});
    }

    @Override
    public void clickDay(String day) {
        this.element().$$(".n2o-calendar-day").filter(Condition.text((String)day)).exclude(Condition.cssClass((String)"disabled")).exclude(Condition.cssClass((String)"other-month")).get(0).shouldBe(new Condition[]{Condition.exist}).click();
    }

    @Override
    public void shouldBeDisableDay(String day) {
        this.element().$$(".n2o-calendar-day.disabled").find(Condition.text((String)day)).shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeDisableDay(String day) {
        this.element().$$(".n2o-calendar-day.disabled").find(Condition.text((String)day)).shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldHaveCurrentMonth(String month) {
        this.element().$(".n2o-calendar-header-month-title").shouldHave(new Condition[]{Condition.text((String)month)});
    }

    @Override
    public void shouldHaveCurrentYear(String year) {
        this.element().$(".n2o-calendar-header-year-title").shouldHave(new Condition[]{Condition.text((String)year)});
    }

    @Override
    public void clickPreviousMonthButton() {
        this.element().$(".n2o-calendar-header .fa-angle-left").click();
    }

    @Override
    public void clickNextMonthButton() {
        this.element().$(".n2o-calendar-header .fa-angle-right").click();
    }

    @Override
    public void shouldHavePlaceholder(String value) {
        Condition condition = Condition.attribute((String)"placeholder", (String)value);
        SelenideElement elm = this.inputElement();
        if (elm.exists()) {
            elm.shouldHave(new Condition[]{condition});
        } else {
            this.cellInputElement().shouldHave(new Condition[]{condition});
        }
    }

    @Override
    public void expand() {
        this.element().$(".n2o-date-input").should(new Condition[]{Condition.exist}).click();
    }

    @Override
    public void collapse() {
        throw new UnsupportedOperationException("Date pop-up cannot be closed without choosing the date");
    }

    @Override
    public void shouldBeExpanded() {
        this.popUp().shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldBeCollapsed() {
        this.popUp().shouldNotBe(new Condition[]{Condition.exist});
    }

    private SelenideElement inputElement() {
        this.element().shouldBe(new Condition[]{Condition.exist});
        return this.element().$(".n2o-date-input input");
    }

    private SelenideElement cellInputElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }

    private SelenideElement popUp() {
        return this.element().parent().parent().$(".n2o-pop-up");
    }
}

