/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.control.DateInterval;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oDateInterval
extends N2oControl
implements DateInterval {
    @Override
    public void shouldHaveValue(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shouldBeEmpty() {
        this.beginShouldBeEmpty();
        this.endShouldBeEmpty();
    }

    @Override
    public void beginShouldBeEmpty() {
        this.firstInputElement().shouldBe(new Condition[]{Condition.empty});
    }

    @Override
    public void endShouldBeEmpty() {
        this.lastInputElement().shouldBe(new Condition[]{Condition.empty});
    }

    @Override
    public void beginVal(String value) {
        this.firstInputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
        this.element().click();
    }

    @Override
    public void endVal(String value) {
        this.lastInputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
        this.element().click();
    }

    @Override
    public void beginShouldHaveValue(String value) {
        this.element().$(".n2o-date-input-first input").shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.value((String)value)});
    }

    @Override
    public void endShouldHaveValue(String value) {
        this.element().$(".n2o-date-input-last input").shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.value((String)value)});
    }

    @Override
    public void clickCalendarButton() {
        this.lastInputElement().parent().$(".btn.n2o-calendar-button").shouldBe(new Condition[]{Condition.exist}).click();
    }

    @Override
    public void shouldBeBeginActiveDay(String day) {
        this.shouldBeActiveDay(this.firstCalendar(), day);
    }

    @Override
    public void shouldBeEndActiveDay(String day) {
        this.shouldBeActiveDay(this.lastCalendar(), day);
    }

    @Override
    public void shouldBeDisableBeginDay(String day) {
        this.shouldBeDisableDay(this.firstCalendar(), day);
    }

    @Override
    public void shouldBeDisableEndDay(String day) {
        this.shouldBeDisableDay(this.lastCalendar(), day);
    }

    @Override
    public void shouldBeEnableBeginDay(String day) {
        this.shouldBeEnableDay(this.firstCalendar(), day);
    }

    @Override
    public void shouldBeEnableEndDay(String day) {
        this.shouldBeEnableDay(this.lastCalendar(), day);
    }

    @Override
    public void clickBeginDay(String day) {
        this.clickDay(this.firstCalendar(), day);
    }

    @Override
    public void clickEndDay(String day) {
        this.clickDay(this.lastCalendar(), day);
    }

    @Override
    public void beginShouldHaveCurrentMonth(String month) {
        this.shouldHaveCurrentMonth(this.firstCalendar(), month);
    }

    @Override
    public void endShouldHaveCurrentMonth(String month) {
        this.shouldHaveCurrentMonth(this.lastCalendar(), month);
    }

    @Override
    public void beginShouldHaveCurrentYear(String year) {
        this.shouldHaveCurrentYear(this.firstCalendar(), year);
    }

    @Override
    public void endShouldHaveCurrentYear(String year) {
        this.shouldHaveCurrentYear(this.lastCalendar(), year);
    }

    @Override
    public void clickBeginPreviousMonthButton() {
        this.clickPreviousMonthButton(this.firstCalendar());
    }

    @Override
    public void clickEndPreviousMonthButton() {
        this.clickPreviousMonthButton(this.lastCalendar());
    }

    @Override
    public void clickBeginNextMonthButton() {
        this.clickNextMonthButton(this.firstCalendar());
    }

    @Override
    public void clickEndNextMonthButton() {
        this.clickNextMonthButton(this.lastCalendar());
    }

    @Override
    public void beginTimeVal(String hours, String minutes, String seconds) {
        this.timeVal(this.firstCalendar(), hours, minutes, seconds);
    }

    @Override
    public void endTimeVal(String hours, String minutes, String seconds) {
        this.timeVal(this.lastCalendar(), hours, minutes, seconds);
    }

    @Override
    public void expand() {
        this.element().$(".n2o-date-input").should(new Condition[]{Condition.exist}).click();
    }

    @Override
    public void collapse() {
        throw new UnsupportedOperationException("Date pop-up cannot be closed without choosing the date");
    }

    @Override
    public void shouldBeCollapsed() {
        this.popUp().shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldBeExpanded() {
        this.popUp().shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldBeEnabled() {
        this.firstInputElement().shouldBe(new Condition[]{Condition.enabled});
        this.lastInputElement().shouldBe(new Condition[]{Condition.enabled});
    }

    @Override
    public void shouldBeDisabled() {
        this.firstInputElement().shouldBe(new Condition[]{Condition.disabled});
        this.lastInputElement().shouldBe(new Condition[]{Condition.disabled});
    }

    private void timeVal(SelenideElement element, String hours, String minutes, String seconds) {
        element.$(".n2o-calendar-time-container").click();
        element.$$(".n2o-pop-up .hour-picker .n2o-calendar-time-unit").find(Condition.text((String)hours)).click();
        element.$$(".n2o-pop-up .minute-picker .n2o-calendar-time-unit").find(Condition.text((String)minutes)).click();
        element.$$(".n2o-pop-up .second-picker .n2o-calendar-time-unit").find(Condition.text((String)seconds)).click();
        element.$$(".n2o-calendar-time-buttons button").find(Condition.text((String)"\u0412\u044b\u0431\u0440\u0430\u0442\u044c")).click();
    }

    private SelenideElement firstInputElement() {
        return this.element().$(".n2o-date-input-first input");
    }

    private SelenideElement lastInputElement() {
        return this.element().$(".n2o-date-input-last input");
    }

    private SelenideElement firstCalendar() {
        return this.element().$$(".n2o-calendar").get(0);
    }

    private SelenideElement lastCalendar() {
        return this.element().$$(".n2o-calendar").get(1);
    }

    private void shouldBeActiveDay(SelenideElement element, String day) {
        element.$(".n2o-calendar-day.selected").shouldBe(new Condition[]{Condition.exist}).shouldHave(new Condition[]{Condition.text((String)day)});
    }

    private void shouldBeDisableDay(SelenideElement element, String day) {
        element.$$(".n2o-calendar-day.disabled").find(Condition.text((String)day)).shouldBe(new Condition[]{Condition.exist});
    }

    private void shouldBeEnableDay(SelenideElement element, String day) {
        element.$$(".n2o-calendar-day.disabled").find(Condition.text((String)day)).shouldNotBe(new Condition[]{Condition.exist});
    }

    private void clickDay(SelenideElement element, String day) {
        element.$$(".n2o-calendar-day").filter(Condition.text((String)day)).exclude(Condition.cssClass((String)"disabled")).exclude(Condition.cssClass((String)"other-month")).get(0).shouldBe(new Condition[]{Condition.exist}).click();
    }

    private void shouldHaveCurrentMonth(SelenideElement element, String month) {
        element.$(".n2o-calendar-header-month-title").shouldHave(new Condition[]{Condition.text((String)month)});
    }

    private void shouldHaveCurrentYear(SelenideElement element, String year) {
        element.$(".n2o-calendar-header-year-title").shouldHave(new Condition[]{Condition.text((String)year)});
    }

    private void clickPreviousMonthButton(SelenideElement element) {
        element.$(".n2o-calendar-header .fa-angle-left").click();
    }

    private void clickNextMonthButton(SelenideElement element) {
        element.$(".n2o-calendar-header .fa-angle-right").click();
    }

    private SelenideElement popUp() {
        return this.element().parent().parent().$(".n2o-pop-up");
    }
}

