/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import java.io.File;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ImageShape;
import net.n2oapp.framework.autotest.api.component.control.ImageUploadControl;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oImageUploadControl
extends N2oControl
implements ImageUploadControl {
    @Override
    public void shouldBeEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shouldHaveValue(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File uploadImage(File ... file) {
        return this.element().$("input").uploadFile(file);
    }

    @Override
    public File uploadFromClasspath(String ... fileName) {
        return this.element().$("input").uploadFromClasspath(fileName);
    }

    @Override
    public void shouldHaveDeleteButton(int index) {
        this.getTrashElement(index).shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldNotHaveDeleteButton(int index) {
        this.getTrashElement(index).shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void deleteImage(int index) {
        this.getTrashElement(index).hover().shouldBe(new Condition[]{Condition.visible}).click();
    }

    @Override
    public void shouldHavePreview(int index) {
        this.getPreviewElement(index).shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldNotHavePreview(int index) {
        this.getPreviewElement(index).shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public ImageUploadControl.PreviewDialog openPreviewDialog(Page page, int index) {
        this.getPreviewElement(index).hover().shouldBe(new Condition[]{Condition.visible}).click();
        return new PreviewDialogImpl(page);
    }

    @Override
    public void shouldHaveSize(int size) {
        this.getFilesItems().shouldHaveSize(size);
    }

    @Override
    public void nameInfoShouldExist(int index) {
        this.getNameElement(index).shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void nameInfoShouldNotExist(int index) {
        this.getNameElement(index).shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void nameShouldBe(int index, String fileName) {
        this.getNameElement(index).shouldHave(new Condition[]{Condition.text((String)fileName)});
    }

    @Override
    public void sizeInfoShouldBeVisible(int index) {
        this.getSizeElement(index).shouldBe(new Condition[]{Condition.visible});
    }

    @Override
    public void sizeInfoShouldNotBeVisible(int index) {
        this.getSizeElement(index).shouldNotBe(new Condition[]{Condition.visible});
    }

    @Override
    public void sizeShouldBe(int index, String fileSize) {
        this.getSizeElement(index).shouldHave(new Condition[]{Condition.text((String)fileSize)});
    }

    @Override
    public void uploadAreaShapeShouldBe(ImageShape shape) {
        switch (shape) {
            case circle: {
                this.element().shouldHave(new Condition[]{Condition.cssClass((String)"n2o-image-uploader-control--shape-circle")});
            }
        }
    }

    @Override
    public void uploadAreaShouldHaveIcon(String icon) {
        this.getUploadAreaElement().shouldHave(new Condition[]{Condition.attribute((String)"class", (String)icon)});
    }

    @Override
    public void uploadAreaIconShouldHaveSize(int size) {
        this.getUploadAreaElement().shouldHave(new Condition[]{Condition.attributeMatching((String)"style", (String)(".*font-size: " + size + "px.*"))});
    }

    @Override
    public void uploadAreaShouldHaveWidth(int width) {
        this.element().shouldHave(new Condition[]{Condition.attributeMatching((String)"style", (String)(".*max-width: " + width + "px.*"))});
    }

    @Override
    public void uploadAreaShouldHaveHeight(int height) {
        this.element().shouldHave(new Condition[]{Condition.attributeMatching((String)"style", (String)(".*max-height: " + height + "px.*"))});
    }

    private ElementsCollection getFilesItems() {
        return this.element().parent().$$(".n2o-file-uploader-files-item-info");
    }

    private SelenideElement getPreviewElement(int index) {
        return this.getFilesItems().get(index).$(".n2o-image-uploader__watch .n2o-image-uploader__watch--eye");
    }

    private SelenideElement getNameElement(int index) {
        return this.getFilesItems().get(index).$(".n2o-image-uploader-img-info .n2o-image-uploader-img-info__file-name");
    }

    private SelenideElement getSizeElement(int index) {
        return this.getFilesItems().get(index).$(".n2o-image-uploader-img-info .n2o-image-uploader-img-info__file-size");
    }

    private SelenideElement getUploadAreaElement() {
        return this.element().$("div");
    }

    private SelenideElement getTrashElement(int index) {
        return this.getFilesItems().get(index).$(".n2o-image-uploader__watch .n2o-image-uploader__watch--trash");
    }

    public static class PreviewDialogImpl
    implements ImageUploadControl.PreviewDialog {
        private SelenideElement element;

        public PreviewDialogImpl(Page page) {
            this.element = page.element().$(".n2o-image-uploader__modal--body");
        }

        @Override
        public void shouldExists() {
            this.element.should(new Condition[]{Condition.exist});
        }

        @Override
        public void shouldHaveLink(String link) {
            this.element.$(".n2o-image-uploader__modal--image").shouldHave(new Condition[]{Condition.attribute((String)"src", (String)link)});
        }

        @Override
        public void close() {
            this.element.$(".n2o-image-uploader__modal--icon-close").click();
        }
    }
}

