/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.n2oapp.framework.autotest.Colors;
import net.n2oapp.framework.autotest.api.component.control.InputSelect;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oInputSelect
extends N2oControl
implements InputSelect {
    private boolean isMulti() {
        return this.input().has(Condition.cssClass((String)"n2o-inp--multi"));
    }

    @Override
    public void click() {
        this.element().$(".n2o-input-items").click();
    }

    @Override
    public void val(String value) {
        this.input().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
        this.element().click();
    }

    @Override
    public void valMulti(String ... values) {
        Arrays.stream(values).forEach(s -> {
            this.element().$(".n2o-inp--multi").sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), s});
            this.element().$(".n2o-inp--multi").pressEnter();
        });
    }

    @Override
    public void shouldHaveValue(String value) {
        this.input().shouldHave(new Condition[]{Condition.value((String)value)});
    }

    @Override
    public void shouldHaveOptions(String ... options) {
        this.expand();
        this.selectPopUp().$$("button .text-cropped,.custom-control-label").shouldHave(new CollectionCondition[]{CollectionCondition.exactTexts((String[])options)});
    }

    @Override
    public void select(int index) {
        this.expand();
        this.popUpButtons().shouldBe(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)index)}).get(index).click();
    }

    @Override
    public void select(Condition by) {
        this.expand();
        this.popUpButtons().findBy(by).click();
    }

    @Override
    public void selectMulti(int ... indexes) {
        this.expand();
        IntStream.of(indexes).forEach(i -> this.popUpButtons().shouldBe(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)i)}).get(i).click());
    }

    @Override
    public void shouldSelected(String value) {
        this.element().$(".n2o-input-items .n2o-inp").shouldHave(new Condition[]{Condition.value((String)value)});
    }

    @Override
    public void shouldBeEmpty() {
        this.element().$(".n2o-input-items .n2o-inp").shouldBe(new Condition[]{Condition.empty});
        if (this.isMulti()) {
            this.shouldSelectedMulti(new String[0]);
        }
    }

    @Override
    public void shouldSelectedMulti(String ... values) {
        ElementsCollection selectedItems = this.element().$$(".selected-item");
        selectedItems.shouldHaveSize(values.length);
        if (values.length != 0) {
            selectedItems.shouldHave(new CollectionCondition[]{CollectionCondition.textsInAnyOrder((String[])values)});
        }
    }

    @Override
    public void itemShouldBeEnabled(Boolean enabled, String value) {
        this.element().click();
        if (enabled.booleanValue()) {
            this.popUpButtons().findBy(Condition.text((String)value)).shouldNotHave(new Condition[]{Condition.cssClass((String)"disabled")});
        } else {
            this.popUpButtons().findBy(Condition.text((String)value)).shouldHave(new Condition[]{Condition.cssClass((String)"disabled")});
        }
    }

    @Override
    public void clear() {
        this.element().$(".n2o-input-clear").hover().shouldBe(new Condition[]{Condition.visible}).click();
    }

    @Override
    public void clearItems(String ... items) {
        ElementsCollection selectedItems = this.element().$$(".selected-item");
        Arrays.stream(items).forEach(s -> selectedItems.find(Condition.text((String)s)).$("button").click());
    }

    @Override
    public void shouldBeDisabled() {
        this.element().shouldHave(new Condition[]{Condition.cssClass((String)"disabled")});
    }

    @Override
    public void expand() {
        SelenideElement elm = this.element().$(".n2o-popup-control");
        if (!elm.is(Condition.cssClass((String)"isExpanded"))) {
            elm.click();
        }
    }

    @Override
    public void collapse() {
        SelenideElement elm = this.element().$(".n2o-popup-control");
        if (elm.is(Condition.cssClass((String)"isExpanded"))) {
            elm.click();
        }
    }

    @Override
    public void shouldBeExpanded() {
        this.selectPopUp().shouldNotBe(new Condition[]{Condition.hidden});
    }

    @Override
    public void shouldBeCollapsed() {
        this.selectPopUp().shouldBe(new Condition[]{Condition.hidden});
    }

    @Override
    public void optionShouldHaveDescription(String option, String description) {
        this.expand();
        SelenideElement elm = this.selectPopUp().$$("button .text-cropped,.custom-control-label").findBy(Condition.text((String)option)).parent();
        if (elm.is(Condition.cssClass((String)"custom-checkbox"))) {
            elm = elm.parent();
        }
        elm.$(".dropdown-header").shouldHave(new Condition[]{Condition.text((String)description)});
    }

    @Override
    public void itemShouldHaveStatusColor(String value, Colors color) {
        this.element().click();
        this.popUpButtons().findBy(Condition.text((String)value)).$(".n2o-status-text_icon__right, .n2o-status-text_icon__left").shouldHave(new Condition[]{Condition.cssClass((String)color.name("bg-"))});
    }

    private SelenideElement input() {
        return this.element().$(".n2o-inp");
    }

    private SelenideElement selectPopUp() {
        return this.element().parent().parent().$(".n2o-pop-up");
    }

    private ElementsCollection popUpButtons() {
        return this.selectPopUp().$$("button");
    }
}

