/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.control.InputText;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oInputText
extends N2oControl
implements InputText {
    @Override
    public void shouldBeEmpty() {
        SelenideElement elm = this.inputElement();
        if (elm.exists()) {
            this.inputElement().shouldBe(new Condition[]{Condition.empty});
        } else {
            this.cellInputElement().shouldBe(new Condition[]{Condition.empty});
        }
    }

    @Override
    public String val() {
        SelenideElement elm = this.inputElement();
        return elm.exists() ? elm.val() : this.cellInputElement().text();
    }

    @Override
    public void val(String value) {
        this.inputElement().click();
        this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
    }

    @Override
    public void clear() {
        this.inputElement().click();
        this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), Keys.BACK_SPACE});
    }

    @Override
    public void shouldHaveValue(String value) {
        SelenideElement elm = this.inputElement();
        if (elm.exists()) {
            elm.shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.exactValue((String)value)});
        } else {
            this.cellInputElement().shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.selectedText((String)value)});
        }
    }

    @Override
    public void shouldHavePlaceholder(String placeholder) {
        Condition condition = Condition.attribute((String)"placeholder", (String)placeholder);
        SelenideElement elm = this.inputElement();
        if (elm.exists()) {
            elm.shouldHave(new Condition[]{condition});
        } else {
            this.cellInputElement().shouldHave(new Condition[]{condition});
        }
    }

    @Override
    public void clickPlusStepButton() {
        this.element().parent().$$(".n2o-input-number-buttons button").get(0).click();
    }

    @Override
    public void clickMinusStepButton() {
        this.element().parent().$$(".n2o-input-number-buttons button").get(1).click();
    }

    @Override
    public void shouldHaveMeasure() {
        this.inputMeasure().should(new Condition[]{Condition.exist});
    }

    @Override
    public void measureShouldHaveText(String text) {
        this.inputMeasure().shouldHave(new Condition[]{Condition.text((String)text)});
    }

    private SelenideElement inputElement() {
        this.element().shouldBe(new Condition[]{Condition.exist});
        return this.element().parent().$(".n2o-input");
    }

    private SelenideElement cellInputElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }

    private SelenideElement inputMeasure() {
        SelenideElement elm = this.element().parent();
        if (elm.is(Condition.cssClass((String)"n2o-input-number"))) {
            elm = elm.parent();
        }
        return elm.$(".n2o-control-container-placeholder");
    }
}

