/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.control.MaskedInput;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oMaskedInput
extends N2oControl
implements MaskedInput {
    @Override
    public void shouldBeEmpty() {
        SelenideElement elm = this.inputElement();
        if (elm.exists()) {
            this.inputElement().shouldBe(new Condition[]{Condition.empty});
        } else {
            this.cellInputElement().shouldBe(new Condition[]{Condition.empty});
        }
    }

    @Override
    public String val() {
        SelenideElement elm = this.inputElement();
        return elm.exists() ? elm.val() : this.cellInputElement().text();
    }

    @Override
    public void val(String value) {
        this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
        this.inputElement().pressEnter();
    }

    @Override
    public void shouldHaveValue(String value) {
        SelenideElement elm = this.element().parent().$(".n2o-input-mask");
        if (elm.exists()) {
            elm.shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.value((String)value)});
        } else {
            this.element().$(".n2o-editable-cell .n2o-editable-cell-text").shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.text((String)value)});
        }
    }

    @Override
    public void shouldHavePlaceholder(String value) {
        Condition condition = Condition.attribute((String)"placeholder", (String)value);
        SelenideElement elm = this.element().parent().$(".n2o-input-mask");
        if (elm.exists()) {
            elm.shouldHave(new Condition[]{condition});
        } else {
            this.element().$(".n2o-editable-cell .n2o-editable-cell-text").shouldHave(new Condition[]{condition});
        }
    }

    @Override
    public void shouldHaveMeasure() {
        this.inputMeasure().should(new Condition[]{Condition.exist});
    }

    @Override
    public void measureShouldHaveText(String text) {
        this.inputMeasure().shouldHave(new Condition[]{Condition.text((String)text)});
    }

    private SelenideElement inputElement() {
        this.element().shouldBe(new Condition[]{Condition.exist});
        return this.element().parent().$(".n2o-input-mask");
    }

    private SelenideElement cellInputElement() {
        return this.element().$(".n2o-editable-cell .n2o-editable-cell-text");
    }

    private SelenideElement inputMeasure() {
        return this.element().parent().$(".n2o-control-container-placeholder");
    }
}

