/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.control.NumberPicker;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oNumberPicker
extends N2oControl
implements NumberPicker {
    @Override
    public void shouldBeEmpty() {
        this.inputElement().shouldBe(new Condition[]{Condition.empty});
    }

    @Override
    public void val(String value) {
        this.inputElement().click();
        this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), value});
        this.inputElement().pressTab();
    }

    @Override
    public void clear() {
        this.inputElement().click();
        this.inputElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}), Keys.BACK_SPACE});
        this.inputElement().pressTab();
    }

    @Override
    public void shouldHaveValue(String value) {
        this.inputElement().shouldHave(new Condition[]{value == null || value.isEmpty() ? Condition.empty : Condition.value((String)value)});
    }

    @Override
    public void clickPlusStepButton() {
        this.plusButton().click();
    }

    @Override
    public void minusStepButtonShouldBeEnabled() {
        this.minusButton().parent().shouldBe(new Condition[]{Condition.enabled});
    }

    @Override
    public void minusStepButtonShouldBeDisabled() {
        this.minusButton().parent().shouldBe(new Condition[]{Condition.disabled});
    }

    @Override
    public void clickMinusStepButton() {
        this.element().parent().$$(".n2o-number-picker__button .fa-minus").get(0).click();
    }

    @Override
    public void plusStepButtonShouldBeEnabled() {
        this.plusButton().parent().shouldBe(new Condition[]{Condition.enabled});
    }

    @Override
    public void plusStepButtonShouldBeDisabled() {
        this.plusButton().parent().shouldBe(new Condition[]{Condition.disabled});
    }

    @Override
    public void minShouldBe(String val) {
        this.inputElement().shouldBe(new Condition[]{Condition.attribute((String)"min", (String)val)});
    }

    @Override
    public void maxShouldBe(String val) {
        this.inputElement().shouldBe(new Condition[]{Condition.attribute((String)"max", (String)val)});
    }

    @Override
    public void stepShouldBe(String val) {
        this.inputElement().shouldBe(new Condition[]{Condition.attribute((String)"step", (String)val)});
    }

    private SelenideElement inputElement() {
        this.element().shouldBe(new Condition[]{Condition.exist});
        return this.element().parent().$(".n2o-number-picker__input");
    }

    private SelenideElement minusButton() {
        return this.element().parent().$(".n2o-number-picker__button .fa-minus");
    }

    private SelenideElement plusButton() {
        return this.element().parent().$(".n2o-number-picker__button .fa-plus");
    }
}

