/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.control.Select;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;
import org.openqa.selenium.Keys;

public class N2oSelect
extends N2oControl
implements Select {
    @Override
    public void shouldHaveValue(String value) {
        this.shouldSelected(value);
    }

    @Override
    public void shouldBeEmpty() {
        this.element().$(".n2o-input-items").shouldBe(new Condition[]{Condition.empty});
    }

    @Override
    public void find(String query) {
        this.element().$(".n2o-input-items input").sendKeys(new CharSequence[]{query, Keys.ARROW_DOWN});
    }

    @Override
    public void click() {
        this.element().$(".n2o-input-items").click();
    }

    @Override
    public void shouldHaveOptions(String ... options) {
        this.expand();
        this.selectPopUp().$$("button .text-cropped,.custom-control-label").shouldHave(new CollectionCondition[]{CollectionCondition.exactTexts((String[])options)});
    }

    @Override
    public void select(int index) {
        this.expand();
        this.selectPopUp().$$("button").shouldBe(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)index)}).get(index).click();
    }

    @Override
    public void select(Condition by) {
        this.expand();
        this.selectPopUp().$$("button").findBy(by).click();
    }

    @Override
    public void selectMulti(int ... indexes) {
        if (this.element().$(".n2o-popup-control.isExpanded").is(Condition.not((Condition)Condition.exist))) {
            this.expand();
        }
        for (int index : indexes) {
            this.selectPopUp().$$(".n2o-input").shouldBe(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)index)}).get(index).click();
        }
    }

    @Override
    public void shouldSelected(String value) {
        this.element().$(".n2o-input-items").shouldHave(new Condition[]{Condition.text((String)value)});
    }

    @Override
    public void shouldBeChecked(int ... indexes) {
        for (int index : indexes) {
            this.selectPopUp().$$(".n2o-input").shouldBe(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)index)}).get(index).shouldBe(new Condition[]{Condition.checked});
        }
    }

    @Override
    public void shouldNotBeChecked(int ... indexes) {
        for (int index : indexes) {
            this.selectPopUp().$$(".n2o-input").shouldBe(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)index)}).get(index).shouldNotBe(new Condition[]{Condition.checked});
        }
    }

    @Override
    public void clear() {
        this.element().$(".n2o-input-clear").hover().shouldBe(new Condition[]{Condition.visible}).click();
    }

    @Override
    public void shouldBeCleanable() {
        this.element().$$(".n2o-input-clear").shouldHave(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)0)});
    }

    @Override
    public void shouldNotBeCleanable() {
        this.element().$$(".n2o-input-clear").shouldHave(new CollectionCondition[]{CollectionCondition.size((int)0)});
    }

    @Override
    public void shouldBeDisabled() {
        this.element().shouldHave(new Condition[]{Condition.cssClass((String)"disabled")});
    }

    @Override
    public void expand() {
        SelenideElement elm = this.element().$(".n2o-popup-control");
        if (!elm.is(Condition.cssClass((String)"isExpanded"))) {
            elm.click();
        }
    }

    @Override
    public void collapse() {
        SelenideElement elm = this.element().$(".n2o-popup-control");
        if (elm.is(Condition.cssClass((String)"isExpanded"))) {
            elm.click();
        }
    }

    @Override
    public void shouldBeExpanded() {
        this.selectPopUp().shouldNotBe(new Condition[]{Condition.hidden});
    }

    @Override
    public void shouldBeCollapsed() {
        this.selectPopUp().shouldBe(new Condition[]{Condition.hidden});
    }

    @Override
    public void optionShouldHaveDescription(String option, String description) {
        this.expand();
        SelenideElement elm = this.selectPopUp().$$("button .text-cropped,.custom-control-label").findBy(Condition.text((String)option)).parent();
        if (elm.is(Condition.cssClass((String)"custom-checkbox"))) {
            elm = elm.parent();
        }
        elm.$(".dropdown-header").shouldHave(new Condition[]{Condition.text((String)description)});
    }

    private SelenideElement selectPopUp() {
        return this.element().parent().parent().$(".n2o-select-pop-up");
    }
}

