/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.control;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.control.TimePicker;
import net.n2oapp.framework.autotest.impl.component.control.N2oControl;

public class N2oTimePicker
extends N2oControl
implements TimePicker {
    @Override
    public void shouldBeEmpty() {
        this.shouldHaveValue("");
    }

    @Override
    public void selectHoursMinutesSeconds(String hours, String minutes, String seconds) {
        this.expand();
        this.hoursItems().get(Integer.parseInt(hours)).click();
        this.minutesItems().get(Integer.parseInt(minutes)).click();
        this.secondsItems().get(Integer.parseInt(seconds)).click();
        this.collapse();
    }

    @Override
    public void selectMinutesSeconds(String minutes, String seconds) {
        this.expand();
        this.minutesItems().get(Integer.parseInt(minutes)).click();
        this.secondsItems().get(Integer.parseInt(seconds)).click();
        this.collapse();
    }

    @Override
    public void selectHours(String hours) {
        this.expand();
        this.hoursItems().get(Integer.parseInt(hours)).click();
        this.collapse();
    }

    @Override
    public void selectMinutes(String minutes) {
        this.expand();
        this.minutesItems().get(Integer.parseInt(minutes)).click();
        this.collapse();
    }

    @Override
    public void shouldHaveValue(String value) {
        this.element().$(".n2o-input").shouldHave(new Condition[]{Condition.attribute((String)"value", (String)value)});
    }

    @Override
    public void shouldSelectedHoursMinutesSeconds(String hours, String minutes, String seconds) {
        this.expand();
        this.hoursActiveItem().shouldHave(new Condition[]{Condition.text((String)hours)});
        this.minutesActiveItem().shouldHave(new Condition[]{Condition.text((String)minutes)});
        this.secondsActiveItem().shouldHave(new Condition[]{Condition.text((String)seconds)});
        this.collapse();
    }

    @Override
    public void shouldSelectedHoursMinutes(String hours, String minutes) {
        this.expand();
        this.hoursActiveItem().shouldHave(new Condition[]{Condition.text((String)hours)});
        this.minutesActiveItem().shouldHave(new Condition[]{Condition.text((String)minutes)});
        this.collapse();
    }

    @Override
    public void shouldSelectedHours(String hours) {
        this.expand();
        this.hoursActiveItem().shouldHave(new Condition[]{Condition.text((String)hours)});
        this.collapse();
    }

    @Override
    public void shouldSelectedMinutes(String minutes) {
        this.expand();
        this.minutesActiveItem().shouldHave(new Condition[]{Condition.text((String)minutes)});
        this.collapse();
    }

    @Override
    public void shouldHavePrefix(String prefix) {
        this.prefix().shouldHave(new Condition[]{Condition.text((String)prefix)});
    }

    @Override
    public void shouldNotHavePrefix() {
        this.prefix().shouldNot(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldBeExpanded() {
        this.popUp().shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldBeCollapsed() {
        this.popUp().shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void expand() {
        if (!this.popUp().is(Condition.exist)) {
            this.element().$(".n2o-input-icon").click();
        }
    }

    @Override
    public void collapse() {
        if (this.popUp().is(Condition.exist)) {
            this.element().$(".n2o-input-icon").click();
        }
    }

    private SelenideElement popUp() {
        return this.element().parent().parent().$(".n2o-pop-up");
    }

    private SelenideElement prefix() {
        return this.element().$(".time-prefix");
    }

    private ElementsCollection items(String title) {
        return this.popUp().$$(".n2o-time-picker__header").findBy(Condition.text((String)title)).parent().$$(".dropdown-item");
    }

    private ElementsCollection hoursItems() {
        return this.items("\u0447\u0430\u0441\u044b");
    }

    private ElementsCollection minutesItems() {
        return this.items("\u043c\u0438\u043d\u0443\u0442\u044b");
    }

    private ElementsCollection secondsItems() {
        return this.items("\u0441\u0435\u043a\u0443\u043d\u0434\u044b");
    }

    private SelenideElement hoursActiveItem() {
        return this.hoursItems().findBy(Condition.cssClass((String)"active"));
    }

    private SelenideElement minutesActiveItem() {
        return this.minutesItems().findBy(Condition.cssClass((String)"active"));
    }

    private SelenideElement secondsActiveItem() {
        return this.secondsItems().findBy(Condition.cssClass((String)"active"));
    }
}

