/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.drawer;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Toolbar;
import net.n2oapp.framework.autotest.api.component.drawer.Drawer;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import org.openqa.selenium.WebElement;

public class N2oDrawer
extends N2oComponent
implements Drawer {
    @Override
    public <T extends Page> T content(Class<T> pageClass) {
        return (T)((Page)N2oSelenide.component(this.element().$(".drawer-content .n2o-page-body"), pageClass));
    }

    @Override
    public Drawer.DrawerToolbar toolbar() {
        return new N2oDrawerToolbar();
    }

    @Override
    public void shouldHaveTitle(String text) {
        this.element().$(".drawer-title").shouldHave(new Condition[]{Condition.text((String)text)});
    }

    @Override
    public void placementShouldBe(Drawer.Placement placement) {
        this.element().shouldHave(new Condition[]{Condition.cssClass((String)("drawer-" + placement.name()))});
    }

    @Override
    public void widthShouldBe(String width) {
        this.element().$(".drawer-content-wrapper").shouldHave(new Condition[]{new StyleAttribute("width", width)});
    }

    @Override
    public void heightShouldBe(String height) {
        this.element().$(".drawer-content-wrapper").shouldHave(new Condition[]{new StyleAttribute("height", height)});
    }

    @Override
    public void close() {
        this.element().$(".drawer-handle").click();
    }

    @Override
    public void closeByEsc() {
        this.element().pressEscape();
    }

    @Override
    public void clickBackdrop() {
        this.element().click();
    }

    @Override
    public void footerShouldBeFixed() {
        this.getFooter().shouldBe(new Condition[]{Condition.cssClass((String)"drawer-footer--fixed")});
    }

    @Override
    public void footerShouldNotBeFixed() {
        this.getFooter().shouldNotBe(new Condition[]{Condition.cssClass((String)"drawer-footer--fixed")});
    }

    @Override
    public void scrollUp() {
        Selenide.executeJavaScript((String)"document.querySelector('.n2o-drawer-children-wrapper').scrollTop = 0", (Object[])new Object[0]);
    }

    @Override
    public void scrollDown() {
        Selenide.executeJavaScript((String)"document.querySelector('.n2o-drawer-children-wrapper').scrollTop = document.querySelector('.n2o-drawer-children-wrapper').scrollHeight", (Object[])new Object[0]);
    }

    private SelenideElement getFooter() {
        return this.element().$(".drawer-footer");
    }

    public class N2oDrawerToolbar
    implements Drawer.DrawerToolbar {
        @Override
        public Toolbar bottomLeft() {
            return N2oSelenide.collection(N2oDrawer.this.element().$$(".drawer-footer .n2o-modal-actions").first().$$(".btn"), Toolbar.class);
        }

        @Override
        public Toolbar bottomRight() {
            return N2oSelenide.collection(N2oDrawer.this.element().$$(".drawer-footer .n2o-modal-actions").last().$$(".btn"), Toolbar.class);
        }
    }

    static class StyleAttribute
    extends Condition {
        private final String attributeName;
        private final String expectedAttributeValue;

        StyleAttribute(String attributeName, String expectedAttributeValue) {
            super("attribute");
            this.attributeName = attributeName;
            this.expectedAttributeValue = expectedAttributeValue;
        }

        public boolean apply(Driver driver, WebElement element) {
            return this.getAttributeValue(element).contains(this.attributeName + ": " + this.expectedAttributeValue);
        }

        public String actualValue(Driver driver, WebElement element) {
            return String.format("style=\"%s\"", this.getAttributeValue(element));
        }

        public String toString() {
            return String.format("attribute style contains %s: %s", this.attributeName, this.expectedAttributeValue);
        }

        private String getAttributeValue(WebElement element) {
            String attr = element.getAttribute("style");
            return attr == null ? "" : attr;
        }
    }
}

