/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.header;

import com.codeborne.selenide.Condition;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ImageShape;
import net.n2oapp.framework.autotest.api.component.header.MenuItem;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public abstract class N2oMenuItem
extends N2oComponent
implements MenuItem {
    @Override
    public void shouldHaveImage() {
        this.element().$("img").shouldHave(new Condition[]{Condition.exist});
    }

    @Override
    public void imageSrcShouldBe(String src) {
        this.element().$("img").shouldHave(new Condition[]{Condition.attribute((String)"src", (String)src)});
    }

    @Override
    public void imageShouldHaveShape(ImageShape shape) {
        switch (shape) {
            case square: {
                this.checkShape("mr-2 ");
                break;
            }
            case rounded: {
                this.checkShape("mr-2 " + shape);
                break;
            }
            case circle: {
                this.checkShape("mr-2 rounded-" + shape);
            }
        }
    }

    @Override
    public void labelShouldHave(String text) {
        this.element().shouldHave(new Condition[]{Condition.text((String)text)});
    }

    @Override
    public void click() {
        this.element().shouldBe(new Condition[]{Condition.exist}).click();
    }

    private void checkShape(String shape) {
        this.element().$("img").shouldHave(new Condition[]{Condition.attribute((String)"class", (String)shape)});
    }
}

