/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.modal;

import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Toolbar;
import net.n2oapp.framework.autotest.api.component.modal.Modal;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oModal
extends N2oComponent
implements Modal {
    @Override
    public void shouldHaveTitle(String text) {
        this.element().$(".modal-header .modal-title").shouldHave(new Condition[]{Condition.text((String)text)});
    }

    @Override
    public void shouldNotHaveHeader() {
        this.element().$(".modal-header").shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public Modal.ModalToolbar toolbar() {
        return new N2oModalToolbar();
    }

    @Override
    public <T extends Page> T content(Class<T> pageClass) {
        return (T)((Page)N2oSelenide.component(this.element().$(".modal-body"), pageClass));
    }

    @Override
    public void scrollUp() {
        Selenide.executeJavaScript((String)"document.querySelector('.modal-body').scrollTop = 0", (Object[])new Object[0]);
    }

    @Override
    public void scrollDown() {
        Selenide.executeJavaScript((String)"document.querySelector('.modal-body').scrollTop = document.querySelector('.modal-body').scrollHeight", (Object[])new Object[0]);
    }

    @Override
    public void shouldBeScrollable() {
        this.element().$(".modal-dialog-scrollable .modal-body").should(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeScrollable() {
        this.element().$(".modal-dialog-scrollable .modal-body").shouldNot(new Condition[]{Condition.exist});
    }

    @Override
    public void close() {
        this.element().$(".modal-header .close").click();
    }

    @Override
    public void closeByEsc() {
        this.element().parent().parent().pressEscape();
    }

    @Override
    public void clickBackdrop() {
        int widthOffset = this.element().getSize().getWidth() / 2 + 10;
        this.element().click(ClickOptions.usingDefaultMethod().offsetX(widthOffset));
    }

    public class N2oModalToolbar
    implements Modal.ModalToolbar {
        @Override
        public Toolbar bottomLeft() {
            return N2oSelenide.collection(N2oModal.this.element().$$(".modal-footer .n2o-modal-actions").first().$$(".btn"), Toolbar.class);
        }

        @Override
        public Toolbar bottomRight() {
            return N2oSelenide.collection(N2oModal.this.element().$$(".modal-footer .n2o-modal-actions").last().$$(".btn"), Toolbar.class);
        }
    }
}

