/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.page;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.api.metadata.application.NavigationLayout;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.collection.Alerts;
import net.n2oapp.framework.autotest.api.collection.Toolbar;
import net.n2oapp.framework.autotest.api.component.application.Footer;
import net.n2oapp.framework.autotest.api.component.application.Sidebar;
import net.n2oapp.framework.autotest.api.component.header.SimpleHeader;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import net.n2oapp.framework.autotest.impl.component.application.N2oFooter;
import net.n2oapp.framework.autotest.impl.component.application.N2oSidebar;
import net.n2oapp.framework.autotest.impl.component.header.N2oSimpleHeader;
import org.openqa.selenium.WebElement;

public class N2oPage
extends N2oComponent
implements Page {
    @Override
    public SimpleHeader header() {
        return new N2oSimpleHeader(this.element().$(".n2o-header"));
    }

    @Override
    public Sidebar sidebar() {
        return new N2oSidebar(this.element().$(".n2o-sidebar"));
    }

    @Override
    public Footer footer() {
        return new N2oFooter(this.element().$(".n2o-footer"));
    }

    @Override
    public Page.PageToolbar toolbar() {
        return new N2oPageToolbar();
    }

    @Override
    public Page.Breadcrumb breadcrumb() {
        return new N2oBreadcrumb(this.element().$(".breadcrumb"));
    }

    @Override
    public Page.Dialog dialog(String title) {
        return new N2oDialog(this.element().$$(".modal-dialog").findBy(Condition.text((String)title)).parent());
    }

    @Override
    public Page.Popover popover(String title) {
        return new N2oPopover(this.element().$$(".popover .popover-header").findBy(Condition.text((String)title)).parent());
    }

    @Override
    public Page.Tooltip tooltip() {
        return new N2oTooltip(this.element().$(".list-text-cell__tooltip-container, .show.tooltip"));
    }

    @Override
    public Alerts alerts() {
        return N2oSelenide.collection(this.element().$$(".n2o-alerts-container .n2o-alert"), Alerts.class);
    }

    @Override
    public void urlShouldMatches(String regexp) {
        this.element().should(new Condition[]{new UrlMatch(regexp)});
    }

    @Override
    public void titleShouldHaveText(String title) {
        this.element().$(".n2o-page__title").shouldHave(new Condition[]{Condition.text((String)title)});
    }

    @Override
    public void scrollUp() {
        Selenide.executeJavaScript((String)"window.scrollTo(0, 0)", (Object[])new Object[0]);
    }

    @Override
    public void scrollDown() {
        Selenide.executeJavaScript((String)"window.scrollTo(0, document.body.scrollHeight)", (Object[])new Object[0]);
    }

    @Override
    public void shouldHaveCssClass(String classname) {
        this.element().$(".n2o-page-body").shouldHave(new Condition[]{Condition.cssClass((String)classname)});
    }

    @Override
    public void shouldHaveStyle(String style) {
        this.element().$(".n2o-page-body").shouldHave(new Condition[]{Condition.attribute((String)"style", (String)style)});
    }

    @Override
    public void shouldHaveLayout(NavigationLayout layout) {
        if (NavigationLayout.fullSizeHeader.equals((Object)layout)) {
            this.element().$(".n2o-layout-full-size-header").should(new Condition[]{Condition.exist});
        } else if (NavigationLayout.fullSizeSidebar.equals((Object)layout)) {
            this.element().$(".n2o-layout-full-size-sidebar").should(new Condition[]{Condition.exist});
        }
    }

    static class UrlMatch
    extends Condition {
        private final String regex;

        public UrlMatch(String regex) {
            super("urlMatch", true);
            this.regex = regex;
        }

        public boolean apply(Driver driver, WebElement element) {
            return driver.url().matches(this.regex);
        }

        public String actualValue(Driver driver, WebElement element) {
            return driver.url();
        }

        public String toString() {
            return String.format("%s '%s'", this.getName(), this.regex);
        }
    }

    public static class N2oTooltip
    implements Page.Tooltip {
        private final SelenideElement element;

        public N2oTooltip(SelenideElement element) {
            this.element = element;
        }

        @Override
        public void shouldBeExist() {
            this.element.shouldBe(new Condition[]{Condition.exist});
        }

        @Override
        public void shouldNotBeExist() {
            this.element.shouldNotBe(new Condition[]{Condition.exist});
        }

        @Override
        public void shouldBeEmpty() {
            this.element.shouldBe(new Condition[]{Condition.empty});
        }

        @Override
        public void shouldHaveText(String ... text) {
            ElementsCollection items = this.element.$$(".list-text-cell__tooltip-container__body, .tooltip-inner");
            items.shouldHaveSize(text.length);
            if (text.length != 0) {
                items.shouldHave(new CollectionCondition[]{CollectionCondition.texts((String[])text)});
            }
        }
    }

    public static class N2oPopover
    implements Page.Popover {
        private final SelenideElement element;

        public N2oPopover(SelenideElement element) {
            this.element = element;
        }

        @Override
        public void shouldBeVisible() {
            this.element.isDisplayed();
        }

        @Override
        public void shouldHaveText(String text) {
            this.element.$(".popover-body").shouldHave(new Condition[]{Condition.text((String)text)});
        }

        @Override
        public void click(String label) {
            this.element.$$(".btn").findBy(Condition.text((String)label)).click();
        }

        @Override
        public void shouldBeClosed(long timeOut) {
            if (this.element.$(".popover-header .popover-body").exists()) {
                this.element.$(".popover-header .popover-body").waitWhile(Condition.exist, timeOut);
            }
        }
    }

    public static class N2oDialog
    implements Page.Dialog {
        private final SelenideElement element;

        public N2oDialog(SelenideElement element) {
            this.element = element;
        }

        @Override
        public void shouldBeVisible() {
            this.element.isDisplayed();
        }

        @Override
        public void shouldHaveText(String text) {
            this.element.$(".modal-body").shouldHave(new Condition[]{Condition.text((String)text)});
        }

        @Override
        public void click(String label) {
            this.element.$$(".btn").findBy(Condition.text((String)label)).click();
        }

        @Override
        public void shouldBeClosed(long timeOut) {
            if (this.element.$(".modal-header .modal-title").exists()) {
                this.element.$(".modal-header .modal-title").waitWhile(Condition.exist, timeOut);
            }
        }
    }

    public class N2oBreadcrumb
    extends N2oComponent
    implements Page.Breadcrumb {
        public N2oBreadcrumb(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void clickLink(String text) {
            this.element().$$(".n2o-breadcrumb-link").findBy(Condition.text((String)text)).shouldBe(new Condition[]{Condition.exist}).click();
        }

        @Override
        public void firstTitleShouldHaveText(String text) {
            this.element().$(".breadcrumb-item").shouldHave(new Condition[]{Condition.text((String)text)});
        }

        @Override
        public void titleShouldHaveText(String text) {
            this.element().$(".active.breadcrumb-item").shouldHave(new Condition[]{Condition.text((String)text)});
        }

        @Override
        public void titleByIndexShouldHaveText(String text, Integer index) {
            this.element().$$(".breadcrumb-item").get(index.intValue()).shouldHave(new Condition[]{Condition.text((String)text)});
        }
    }

    public class N2oPageToolbar
    implements Page.PageToolbar {
        @Override
        public Toolbar topLeft() {
            return N2oSelenide.collection(N2oPage.this.element().$$(".n2o-page-body .n2o-page-actions").first().$$(".btn-toolbar:first-child .btn"), Toolbar.class);
        }

        @Override
        public Toolbar topRight() {
            return N2oSelenide.collection(N2oPage.this.element().$$(".n2o-page-body .n2o-page-actions").first().$$(".btn-toolbar:last-child .btn"), Toolbar.class);
        }

        @Override
        public Toolbar bottomLeft() {
            return N2oSelenide.collection(N2oPage.this.element().$$(".n2o-page-body .n2o-page-actions").last().$$(".btn-toolbar:first-child .btn"), Toolbar.class);
        }

        @Override
        public Toolbar bottomRight() {
            return N2oSelenide.collection(N2oPage.this.element().$$(".n2o-page-body .n2o-page-actions").last().$$(".btn-toolbar:last-child .btn"), Toolbar.class);
        }
    }
}

