/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.region;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.region.RegionItems;
import net.n2oapp.framework.autotest.api.component.region.TabsRegion;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;
import net.n2oapp.framework.autotest.impl.component.region.N2oRegion;
import org.openqa.selenium.WebElement;

public class N2oTabsRegion
extends N2oRegion
implements TabsRegion {
    @Override
    public TabsRegion.TabItem tab(int index) {
        return new N2oTabItem(this.element().$$(".n2o-tabs-nav-item").shouldBe(new CollectionCondition[]{CollectionCondition.sizeGreaterThan((int)index)}).get(index));
    }

    @Override
    public void shouldHaveSize(int size) {
        this.element().$$(".n2o-tabs-nav-item").shouldHaveSize(size);
    }

    @Override
    public void shouldHaveMaxHeight(int height) {
        this.getTabsContent().shouldBe(new Condition[]{Condition.attributeMatching((String)"style", (String)(".*max-height: " + height + "px;.*"))});
    }

    @Override
    public void shouldHaveScrollbar() {
        this.getTabsContent().shouldNotHave(new Condition[]{Condition.cssClass((String)"tab-content_no-scrollbar")});
    }

    @Override
    public void shouldNotHaveScrollbar() {
        this.getTabsContent().shouldHave(new Condition[]{Condition.cssClass((String)"tab-content_no-scrollbar")});
    }

    @Override
    public TabsRegion.TabItem tab(Condition by) {
        return new N2oTabItem(this.element().$$(".n2o-tabs-nav-item").findBy(by));
    }

    private SelenideElement getTabsContent() {
        return this.element().$(".tab-content");
    }

    public static class N2oTabItem
    extends N2oComponent
    implements TabsRegion.TabItem {
        public N2oTabItem(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public RegionItems content() {
            SelenideElement elm = this.element().parent().parent().parent().$$(".tab-pane").findBy(Condition.cssClass((String)"active"));
            final ElementsCollection nestingElements = elm.$$(".tab-pane.active .tab-pane.active > div > div");
            ElementsCollection firstLevelElements = elm.$$(".tab-pane.active > div > div").filter(new Condition("shouldBeFirstLevelElement"){

                public boolean apply(Driver driver, WebElement element) {
                    return !nestingElements.contains((Object)element);
                }
            });
            return N2oSelenide.collection(firstLevelElements, RegionItems.class);
        }

        @Override
        public void click() {
            this.element().click();
        }

        @Override
        public void shouldHaveName(String text) {
            this.element().shouldHave(new Condition[]{Condition.text((String)text)});
        }

        @Override
        public void shouldNotHaveTitle() {
            this.element().shouldHave(new Condition[]{Condition.exactText((String)"")});
        }

        @Override
        public void shouldBeActive() {
            this.element().shouldHave(new Condition[]{Condition.cssClass((String)"active")});
        }

        @Override
        public void shouldNotBeActive() {
            this.element().shouldNotHave(new Condition[]{Condition.cssClass((String)"active")});
        }

        @Override
        public void scrollUp() {
            Selenide.executeJavaScript((String)"document.querySelector('.tab-content_fixed').scrollTop = 0", (Object[])new Object[0]);
        }

        @Override
        public void scrollDown() {
            Selenide.executeJavaScript((String)"document.querySelector('.tab-content_fixed').scrollTop = document.querySelector('.tab-content_fixed').scrollHeight", (Object[])new Object[0]);
        }
    }
}

