/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.snippet;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ImageShape;
import net.n2oapp.framework.api.metadata.meta.control.TextPosition;
import net.n2oapp.framework.autotest.api.component.snippet.Image;
import net.n2oapp.framework.autotest.impl.component.snippet.N2oSnippet;

public class N2oImage
extends N2oSnippet
implements Image {
    @Override
    public void shouldHaveTitle(String text) {
        this.imageInfo().$(".n2o-image__info_label").shouldHave(new Condition[]{Condition.text((String)text)});
    }

    @Override
    public void shouldHaveDescription(String text) {
        this.imageInfo().$(".n2o-image__info_description").shouldHave(new Condition[]{Condition.text((String)text)});
    }

    @Override
    public void shouldHaveShape(ImageShape shape) {
        this.element().$(".n2o-image__image-container").should(new Condition[]{Condition.cssClass((String)shape.name())});
    }

    @Override
    public void shouldHaveUrl(String url) {
        this.element().$(".n2o-image__image").should(new Condition[]{Condition.attribute((String)"src", (String)url)});
    }

    @Override
    public void shouldHaveWidth(int width) {
        this.element().$(".n2o-image__image").should(new Condition[]{Condition.attributeMatching((String)"style", (String)(".*width: " + width + "px;.*"))});
    }

    @Override
    public void shouldHaveTextPosition(TextPosition position) {
        this.element().$(".n2o-image__content").should(new Condition[]{Condition.cssClass((String)position.name())});
    }

    @Override
    public void shouldHaveText(String text) {
        this.element().shouldHave(new Condition[]{Condition.text((String)text)});
    }

    private SelenideElement imageInfo() {
        return this.element().parent().parent().$(".n2o-image__info");
    }
}

