/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.widget;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.widget.Paging;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oPaging
extends N2oComponent
implements Paging {
    public N2oPaging(SelenideElement element) {
        this.setElement(element);
    }

    @Override
    public void activePageShouldBe(String label) {
        this.element().$(".n2o-pagination .page-item.active .page-link").shouldHave(new Condition[]{Condition.text((String)label)});
    }

    @Override
    public void selectPage(String number) {
        this.pageNumberButton(number).click();
    }

    @Override
    public void pagingShouldHave(String number) {
        this.pageNumberButton(number).shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldHaveLayout(Paging.Layout layout) {
        this.element().$(".n2o-pagination .pagination").shouldHave(new Condition[]{Condition.cssClass((String)layout.getTitle())});
    }

    @Override
    public int totalElements() {
        String info = this.paginationInfo().text();
        info = info.split(" ")[1];
        return Integer.parseInt(info);
    }

    @Override
    public void totalElementsShouldBe(int count) {
        this.paginationInfo().scrollTo().should(new Condition[]{Condition.matchesText((String)("" + count))});
    }

    @Override
    public void totalElementsShouldNotExist() {
        this.paginationInfo().shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void prevShouldNotExist() {
        this.prevButton().shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void prevShouldExist() {
        this.prevButton().shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void prevShouldHaveLabel(String label) {
        this.prevButton().parent().shouldHave(new Condition[]{Condition.text((String)label)});
    }

    @Override
    public void prevShouldHaveIcon(String icon) {
        this.prevButton().shouldHave(new Condition[]{Condition.cssClass((String)icon)});
    }

    @Override
    public void selectPrev() {
        this.prevButton().click();
    }

    @Override
    public void nextShouldNotExist() {
        this.nextButton().shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void nextShouldExist() {
        this.nextButton().shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void nextShouldHaveLabel(String label) {
        this.nextButton().parent().shouldHave(new Condition[]{Condition.text((String)label)});
    }

    @Override
    public void nextShouldHaveIcon(String icon) {
        this.nextButton().shouldHave(new Condition[]{Condition.cssClass((String)icon)});
    }

    @Override
    public void selectNext() {
        this.nextButton().click();
    }

    @Override
    public void firstShouldNotExist() {
        this.firstButton().shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void firstShouldExist() {
        this.firstButton().shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void firstShouldHaveLabel(String label) {
        this.firstButton().parent().shouldHave(new Condition[]{Condition.text((String)label)});
    }

    @Override
    public void firstShouldHaveIcon(String icon) {
        this.firstButton().shouldHave(new Condition[]{Condition.cssClass((String)icon)});
    }

    @Override
    public void selectFirst() {
        this.firstButton().click();
    }

    @Override
    public void lastShouldNotExist() {
        this.lastButton().shouldNotBe(new Condition[]{Condition.exist});
    }

    @Override
    public void lastShouldExist() {
        this.lastButton().shouldBe(new Condition[]{Condition.exist});
    }

    @Override
    public void lastShouldHaveLabel(String label) {
        this.lastButton().parent().shouldHave(new Condition[]{Condition.text((String)label)});
    }

    @Override
    public void lastShouldHaveIcon(String icon) {
        this.lastButton().shouldHave(new Condition[]{Condition.cssClass((String)icon)});
    }

    @Override
    public void selectLast() {
        this.lastButton().click();
    }

    private SelenideElement pageNumberButton(String number) {
        return this.element().$$(".n2o-pagination .page-link").findBy(Condition.text((String)number));
    }

    private SelenideElement paginationInfo() {
        return this.element().$(".n2o-pagination .n2o-pagination-total");
    }

    private SelenideElement prevButton() {
        return this.element().$(".n2o-pagination .page-link .previous-button");
    }

    private SelenideElement nextButton() {
        return this.element().$(".n2o-pagination .page-link .next-button");
    }

    private SelenideElement firstButton() {
        return this.element().$(".n2o-pagination .page-link .first-button");
    }

    private SelenideElement lastButton() {
        return this.element().$(".n2o-pagination .page-link .last-button");
    }
}

