/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.widget.table;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import net.n2oapp.framework.autotest.api.component.widget.table.TableHeader;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public abstract class N2oTableHeader
extends N2oComponent
implements TableHeader {
    @Override
    public void shouldHaveTitle(String title) {
        this.element().shouldHave(new Condition[]{Condition.text((String)title)});
    }

    @Override
    public void shouldNotHaveTitle() {
        this.element().shouldBe(new Condition[]{Condition.empty});
    }

    @Override
    public void click() {
        SelenideElement elm = this.element().$(".n2o-checkbox");
        if (elm.exists()) {
            elm.click();
        } else {
            this.element().$("a").should(new Condition[]{Condition.exist}).click();
        }
    }

    @Override
    public void shouldNotBeSorted() {
        this.element().$(".n2o-sorting-icon").shouldNot(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldBeSortedByAsc() {
        this.element().$(".n2o-sorting-icon.fa-sort-amount-asc").should(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldBeSortedByDesc() {
        this.element().$(".n2o-sorting-icon.fa-sort-amount-desc").should(new Condition[]{Condition.exist});
    }

    @Override
    public void shouldHaveStyle(String style) {
        SelenideElement elm = this.element().$(".n2o-advanced-table-header-title");
        if (!elm.exists()) {
            elm = this.element().$("div.n2o-advanced-table-header-cel");
        }
        elm.shouldHave(new Condition[]{Condition.attributeMatching((String)"style", (String)(".*" + style + ".*"))});
    }

    @Override
    public void shouldHaveIcon(String icon) {
        this.element().$(".n2o-icon").shouldHave(new Condition[]{Condition.cssClass((String)icon)});
    }

    @Override
    public void shouldNotHaveIcon() {
        this.element().$(".n2o-icon").shouldNotBe(new Condition[]{Condition.exist});
    }
}

