/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.run;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLogger;
import io.qameta.allure.selenide.AllureSelenide;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.compile.SourceTransformer;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.page.Page;
import net.n2oapp.framework.autotest.run.AutoTestApplication;
import net.n2oapp.framework.autotest.run.N2oController;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.metadata.compile.query.TestEngineQueryTransformer;
import net.n2oapp.framework.config.test.N2oTestBase;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@SpringBootTest(classes={AutoTestApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ExtendWith(value={SpringExtension.class})
public class AutoTestBase
extends N2oTestBase {
    @LocalServerPort
    protected int port;
    private N2oController n2oController;

    public static void configureSelenide() {
        SelenideLogger.addListener((String)"AllureSelenide", (LogEventListener)new AllureSelenide());
        System.setProperty("chromeoptions.args", "--no-sandbox,--verbose,--whitelisted-ips=''");
        Configuration.headless = Boolean.parseBoolean(System.getProperty("selenide.headless", "true"));
    }

    public void setUp() throws Exception {
        super.setUp();
        this.n2oController.setUp(this.builder);
    }

    protected void configure(N2oApplicationBuilder builder) {
        super.configure(builder);
        builder.transformers(new SourceTransformer[]{new TestEngineQueryTransformer()});
    }

    protected String getBaseUrl() {
        return "http://localhost:" + this.port;
    }

    protected <T extends Page> T open(Class<T> clazz) {
        return N2oSelenide.open(this.getBaseUrl(), clazz);
    }

    protected <T extends Page> T open(Class<T> clazz, String pageUrl, Map<String, String> queryParams) {
        if (pageUrl == null) {
            pageUrl = "/";
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            pageUrl = (String)pageUrl + "?" + queryParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        }
        return N2oSelenide.open(this.getBaseUrl() + "/#" + (String)pageUrl, clazz);
    }

    protected void setUserInfo(Map<String, Object> user) {
        this.n2oController.addConfigProperty("user", user);
    }

    @Autowired
    public void setN2oController(N2oController n2oController) {
        this.n2oController = n2oController;
    }
}

