/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.run;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class FileStoreController {
    private List<FileModel> fileStore = Collections.synchronizedList(new ArrayList());

    public void clearFileStore() {
        this.fileStore.clear();
    }

    public List<FileModel> getFileStore() {
        return this.fileStore;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"files"})
    public ResponseEntity<FileModel> uploadFile(@RequestParam(value="file") MultipartFile file) throws IOException {
        return new ResponseEntity((Object)this.storeFile(file), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"multi"})
    public ResponseEntity<List<FileModel>> uploadMultiFile(@RequestParam(value="file") MultipartFile[] file) throws IOException {
        ArrayList<FileModel> result = new ArrayList<FileModel>();
        for (MultipartFile mf : file) {
            result.add(this.storeFile(mf));
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"files/{id}"})
    public void deleteFile(@PathVariable String id) {
        for (FileModel fs : this.fileStore) {
            if (!id.equals(fs.id)) continue;
            this.fileStore.remove(fs);
            break;
        }
    }

    public ListResponse getList() {
        return new ListResponse(this.fileStore);
    }

    private FileModel storeFile(MultipartFile file) throws IOException {
        FileModel fm = FileModel.builder().id(UUID.randomUUID().toString()).fileName(file.getOriginalFilename()).url("/files/" + file.getOriginalFilename()).size(file.getSize()).build();
        byte[] cont = file.getBytes();
        MatcherAssert.assertThat((Object)(file.getSize() - (long)cont.length), (Matcher)CoreMatchers.is((Object)0L));
        this.fileStore.add(fm);
        return fm;
    }

    public static class FileModel {
        String id;
        String fileName;
        String url;
        long size;

        FileModel(String id, String fileName, String url, long size) {
            this.id = id;
            this.fileName = fileName;
            this.url = url;
            this.size = size;
        }

        public static FileModelBuilder builder() {
            return new FileModelBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getUrl() {
            return this.url;
        }

        public long getSize() {
            return this.size;
        }

        public static class FileModelBuilder {
            private String id;
            private String fileName;
            private String url;
            private long size;

            FileModelBuilder() {
            }

            public FileModelBuilder id(String id) {
                this.id = id;
                return this;
            }

            public FileModelBuilder fileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            public FileModelBuilder url(String url) {
                this.url = url;
                return this;
            }

            public FileModelBuilder size(long size) {
                this.size = size;
                return this;
            }

            public FileModel build() {
                return new FileModel(this.id, this.fileName, this.url, this.size);
            }

            public String toString() {
                return "FileStoreController.FileModel.FileModelBuilder(id=" + this.id + ", fileName=" + this.fileName + ", url=" + this.url + ", size=" + this.size + ")";
            }
        }
    }

    static class ListResponse {
        @JsonProperty
        final Collection<FileModel> files;

        public Collection<FileModel> getFiles() {
            return this.files;
        }

        public ListResponse(Collection<FileModel> files) {
            this.files = files;
        }
    }
}

