/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.run;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.config.AppConfig;
import net.n2oapp.framework.api.config.ConfigBuilder;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.metadata.application.N2oApplication;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.rest.ControllerFactory;
import net.n2oapp.framework.api.rest.GetDataResponse;
import net.n2oapp.framework.api.rest.SetDataResponse;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.N2oConfigBuilder;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.N2oSubModelsProcessor;
import net.n2oapp.framework.engine.data.N2oOperationProcessor;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;
import net.n2oapp.framework.ui.controller.DataController;
import net.n2oapp.framework.ui.controller.N2oControllerFactory;
import net.n2oapp.framework.ui.controller.action.OperationController;
import net.n2oapp.framework.ui.controller.query.CopyValuesController;
import net.n2oapp.framework.ui.controller.query.QueryController;
import net.n2oapp.framework.ui.controller.query.SimpleDefaultValuesController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class N2oController {
    private N2oApplicationBuilder builder;
    private DataProcessingStack dataProcessingStack;
    private AlertMessageBuilder messageBuilder;
    private QueryProcessor queryProcessor;
    private N2oOperationProcessor operationProcessor;
    private ConfigBuilder<AppConfig> configBuilder;
    private DomainProcessor domainProcessor;
    @Value(value="${n2o.config.path}")
    private String basePath;

    @Autowired
    public N2oController(DataProcessingStack dataProcessingStack, AlertMessageBuilder messageBuilder, QueryProcessor queryProcessor, N2oOperationProcessor operationProcessor, DomainProcessor domainProcessor) {
        this.queryProcessor = queryProcessor;
        this.dataProcessingStack = dataProcessingStack;
        this.messageBuilder = messageBuilder;
        this.operationProcessor = operationProcessor;
        this.domainProcessor = domainProcessor;
    }

    @GetMapping(value={"/n2o/config"})
    public AppConfig config() {
        List apps = this.builder.getEnvironment().getMetadataRegister().find(N2oApplication.class);
        Assert.isTrue((!apps.isEmpty() ? 1 : 0) != 0, (String)"No header metadata found");
        this.configBuilder.menu((Object)((ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)this.builder.read().transform()).validate()).compile()).transform()).bind()).get((CompileContext)new ApplicationContext(((SourceInfo)apps.get(0)).getId()), new DataSet()));
        return this.configBuilder.get();
    }

    @GetMapping(value={"/n2o/page/**", "/n2o/page/", "/n2o/page"})
    public Page page(HttpServletRequest request) {
        String path = this.getPath(request, "/n2o/page");
        CompileContext context = this.builder.route(path, Page.class, request.getParameterMap());
        N2oSubModelsProcessor n2oSubModelsProcessor = new N2oSubModelsProcessor(this.queryProcessor, this.domainProcessor);
        n2oSubModelsProcessor.setEnvironment(this.builder.getEnvironment());
        return (Page)((ReadCompileBindTerminalPipeline)((ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)this.builder.read().transform()).validate()).compile()).transform()).bind()).get(context, context.getParams(path, request.getParameterMap()), (SubModelsProcessor)n2oSubModelsProcessor);
    }

    @GetMapping(value={"/n2o/data/**", "/n2o/data/", "/n2o/data"})
    public ResponseEntity<GetDataResponse> getData(HttpServletRequest request) {
        String path = this.getPath(request, "/n2o/data");
        DataController dataController = new DataController(this.createControllerFactory(this.builder.getEnvironment()), this.builder.getEnvironment());
        dataController.setMessageBuilder(this.messageBuilder);
        GetDataResponse response = dataController.getData(path, request.getParameterMap(), null);
        return ResponseEntity.status((int)response.getStatus()).body((Object)response);
    }

    @PostMapping(value={"/n2o/data/**", "/n2o/data/", "/n2o/data"})
    public ResponseEntity<SetDataResponse> setData(@RequestBody Object body, HttpServletRequest request) {
        String path = this.getPath(request, "/n2o/data");
        DataController dataController = new DataController(this.createControllerFactory(this.builder.getEnvironment()), this.builder.getEnvironment());
        dataController.setMessageBuilder(this.messageBuilder);
        SetDataResponse dataResponse = dataController.setData(path, request.getParameterMap(), this.getHeaders(request), (Object)this.getBody(body), null);
        return ResponseEntity.status((int)dataResponse.getStatus()).body((Object)dataResponse);
    }

    private DataSet getBody(Object body) {
        if (body instanceof Map) {
            return new DataSet((Map)body);
        }
        DataSet dataSet = new DataSet("$list", body);
        dataSet.put("$count", (Object)(body != null ? ((List)body).size() : 0));
        return dataSet;
    }

    public void setUp(N2oApplicationBuilder builder) {
        this.builder = builder;
        this.configBuilder = new N2oConfigBuilder(new AppConfig(), new ObjectMapper(), builder.getEnvironment().getSystemProperties(), builder.getEnvironment().getContextProcessor());
    }

    public void addConfigProperty(String key, Object value) {
        this.configBuilder.add(key, value);
    }

    private ControllerFactory createControllerFactory(MetadataEnvironment environment) {
        N2oSubModelsProcessor subModelsProcessor = new N2oSubModelsProcessor(this.queryProcessor, this.domainProcessor);
        subModelsProcessor.setEnvironment(environment);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("queryController", new QueryController(this.dataProcessingStack, this.queryProcessor, (SubModelsProcessor)subModelsProcessor, this.messageBuilder, environment));
        beans.put("operationController", new OperationController(this.dataProcessingStack, this.operationProcessor, this.messageBuilder, environment));
        beans.put("copyValuesController", new CopyValuesController(this.dataProcessingStack, this.queryProcessor, (SubModelsProcessor)subModelsProcessor, this.messageBuilder, environment));
        beans.put("simpleDefaultValuesController", new SimpleDefaultValuesController(this.dataProcessingStack, this.queryProcessor, (SubModelsProcessor)subModelsProcessor, this.messageBuilder, environment));
        return new N2oControllerFactory(beans);
    }

    private String getPath(HttpServletRequest request, String prefix) {
        String path = request.getRequestURI().substring(request.getRequestURI().indexOf(prefix) + prefix.length());
        return RouteUtil.normalize((String)(!path.isEmpty() ? path : "/"));
    }

    private Map<String, String[]> getHeaders(HttpServletRequest req) {
        HashMap<String, String[]> headers = new HashMap<String, String[]>();
        Enumeration iter = req.getHeaderNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            headers.put(name, new String[]{req.getHeader(name)});
        }
        return headers;
    }
}

