/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.ehcache.monitoring;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.n2oapp.framework.config.ehcache.monitoring.api.CacheConfig;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import org.springframework.cache.CacheManager;

public class CacheTuner {
    private final Map<String, Ehcache> ehcacheMap;
    private final Set<String> enabledStatisticEhcaches = new HashSet<String>();

    public CacheTuner(CacheManager cacheManager, String monitoring) {
        List<String> monitoringList = this.monitoringList(monitoring);
        Collection cacheNames = cacheManager.getCacheNames();
        Map map = cacheNames.stream().map(name -> cacheManager.getCache(name).getNativeCache()).map(Ehcache.class::cast).peek(cache -> this.statisticEnableIfNeed((Ehcache)cache, monitoringList)).collect(Collectors.toMap(Ehcache::getName, Function.identity()));
        this.ehcacheMap = Collections.unmodifiableMap(map);
    }

    public void configure(CacheConfig config) {
        Ehcache ehcache = this.cache(config.name);
        CacheConfiguration configuration = ehcache.getCacheConfiguration();
        CacheConfig prepared = this.prepareToConfigure(config, configuration);
        configuration.setTimeToLiveSeconds(prepared.timeToLive.longValue());
        configuration.setTimeToIdleSeconds(prepared.timeToIdle.longValue());
        if (config.isElementsSettings()) {
            configuration.setMaxEntriesLocalHeap(prepared.maxEntriesLocalHeap.longValue());
            configuration.setMaxEntriesLocalDisk(prepared.maxEntriesLocalDisk.longValue());
        } else {
            configuration.setMaxBytesLocalHeap(prepared.maxBytesLocalHeap);
            configuration.setMaxBytesLocalDisk(prepared.maxBytesLocalDisk);
        }
    }

    public void clearCache(String name) {
        this.cache(name).removeAll();
    }

    public void disableMonitoring(String name) {
    }

    public void enableMonitoring(String name) {
    }

    public void clearStatistic(String name) {
    }

    public Collection<Ehcache> getAllCaches() {
        return this.ehcacheMap.values();
    }

    public Ehcache cache(String name) {
        Ehcache ehcache = this.ehcacheMap.get(name);
        if (ehcache == null) {
            throw new IllegalStateException();
        }
        return ehcache;
    }

    public Set<String> getEnabledStatisticEhcaches() {
        return new HashSet<String>(this.enabledStatisticEhcaches);
    }

    private CacheConfig prepareToConfigure(CacheConfig config, CacheConfiguration configuration) {
        CacheConfig c = new CacheConfig();
        c.name = config.name;
        c.timeToLive = config.timeToLive != null ? config.timeToLive.longValue() : configuration.getTimeToLiveSeconds();
        c.timeToIdle = config.timeToIdle != null ? config.timeToIdle.longValue() : configuration.getTimeToIdleSeconds();
        c.maxBytesLocalDisk = config.maxBytesLocalDisk != null ? config.maxBytesLocalDisk.longValue() : configuration.getMaxBytesLocalDisk();
        c.maxBytesLocalHeap = config.maxBytesLocalHeap != null ? config.maxBytesLocalHeap.longValue() : configuration.getMaxBytesLocalHeap();
        c.maxEntriesLocalDisk = config.maxEntriesLocalDisk != null ? config.maxEntriesLocalDisk.longValue() : configuration.getMaxEntriesLocalDisk();
        c.maxEntriesLocalHeap = config.maxEntriesLocalHeap != null ? config.maxEntriesLocalHeap.longValue() : configuration.getMaxEntriesLocalHeap();
        return c;
    }

    private List<String> monitoringList(String monitoring) {
        if (monitoring.equals("ALL")) {
            return Collections.singletonList(monitoring);
        }
        if (monitoring.equals("NONE")) {
            return Collections.emptyList();
        }
        return Arrays.asList(monitoring.replaceAll("\\s*", "").split(","));
    }

    private void statisticEnableIfNeed(Ehcache ehcache, List<String> list) {
        if (list.contains("ALL") || list.contains(ehcache.getName())) {
            this.enabledStatisticEhcaches.add(ehcache.getName());
        }
    }
}

