/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.ehcache.monitoring.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.CollectionPageService;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.api.Direction;
import net.n2oapp.criteria.api.FilteredCollectionPage;
import net.n2oapp.criteria.api.Sorting;
import net.n2oapp.framework.config.ehcache.monitoring.CacheTuner;
import net.n2oapp.framework.config.ehcache.monitoring.api.CacheCriteria;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.statistics.StatisticsGateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStatisticService
implements CollectionPageService<CacheCriteria, View> {
    private static final String ENTRIES_SIZE = "%s / %s";
    private static final String BYTES_SIZE = "%s / %s %s";
    private static final Logger logger = LoggerFactory.getLogger(CacheStatisticService.class);
    private static final Comparator<View> DEFAULT_COMPARATOR = (v1, v2) -> v1.name.compareToIgnoreCase(v2.name);
    private final CacheTuner tuner;
    private static final double SPACE_KB = 1024.0;
    private static final double SPACE_MB = 1048576.0;
    private static final double SPACE_GB = 1.073741824E9;

    public CacheStatisticService(CacheTuner tuner) {
        this.tuner = tuner;
    }

    public CollectionPage<View> getCollectionPage(CacheCriteria criteria) {
        List views = this.tuner.getAllCaches().stream().map(CacheStatisticService::map).sorted(this.getComparator(criteria)).collect(Collectors.toList());
        return new FilteredCollectionPage(views, (Criteria)criteria);
    }

    private Comparator<View> getComparator(CacheCriteria criteria) {
        if (criteria.getSortings() == null || criteria.getSortings().isEmpty()) {
            return DEFAULT_COMPARATOR;
        }
        Optional<Comparator> usefulness = criteria.getSortings().stream().filter(s -> s.getField().equals("usefulness")).findFirst().map(s -> (v1, v2) -> this.multiplier((Sorting)s) * v1.usefulness.compareTo(v2.usefulness));
        Optional<Comparator> name = criteria.getSortings().stream().filter(s -> s.getField().equals("name")).findFirst().map(s -> (v1, v2) -> this.multiplier((Sorting)s) * v1.name.compareTo(v2.name));
        Optional<Comparator> fullness = criteria.getSortings().stream().filter(s -> s.getField().equals("fullness")).findFirst().map(s -> (v1, v2) -> this.multiplier((Sorting)s) * v1.fullness.compareTo(v2.fullness));
        return usefulness.orElse(name.orElse(fullness.orElse(DEFAULT_COMPARATOR)));
    }

    private int multiplier(Sorting sorting) {
        return sorting.getDirection().equals((Object)Direction.ASC) ? 1 : -1;
    }

    public static View map(Ehcache cache) {
        View v = new View();
        v.name = cache.getName();
        StatisticsGateway statistics = cache.getStatistics();
        v.hits = statistics.cacheHitCount();
        v.miss = statistics.cacheMissCount();
        v.usefulness = new BigDecimal(v.miss != 0L ? (double)v.hits * 1.0 / (double)(v.miss + v.hits) * 100.0 : 0.0).setScale(2, RoundingMode.HALF_UP);
        CacheConfiguration cacheConfiguration = cache.getCacheConfiguration();
        if (cacheConfiguration.getMaxEntriesLocalHeap() != 0L || cacheConfiguration.getMaxEntriesLocalDisk() != 0L) {
            int size = cache.getSize();
            long max = cacheConfiguration.getMaxEntriesLocalHeap() + cacheConfiguration.getMaxEntriesLocalDisk();
            v.fullness = new BigDecimal((double)size * 1.0 / (double)max * 100.0).setScale(2, RoundingMode.HALF_UP);
            v.currentSize = String.format(ENTRIES_SIZE, size, max);
        } else if (cacheConfiguration.getMaxBytesLocalDisk() != 0L || cacheConfiguration.getMaxBytesLocalHeap() != 0L) {
            long size = cache.calculateOffHeapSize() + cache.calculateOnDiskSize();
            long max = cacheConfiguration.getMaxBytesLocalDisk() + cacheConfiguration.getMaxBytesLocalHeap();
            v.fullness = new BigDecimal((double)size * 1.0 / (double)max * 100.0).setScale(2, RoundingMode.HALF_UP);
            v.currentSize = CacheStatisticService.bytes2String(size, max);
        }
        int n = v.fullness.doubleValue() < 70.0 ? 1 : (v.fullnessState = v.fullness.doubleValue() < 90.0 ? 2 : 3);
        v.usefulnessState = v.usefulness.doubleValue() > 80.0 ? 1 : (v.usefulness.doubleValue() > 50.0 ? 2 : 3);
        v.hasTimeEvict = cacheConfiguration.getTimeToLiveSeconds() > 0L || cacheConfiguration.getTimeToIdleSeconds() > 0L;
        return v;
    }

    private static String bytes2String(long size, long max) {
        String sizeName;
        String maxSize;
        String curSize;
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMaximumFractionDigits(2);
        try {
            if ((double)size < 1024.0) {
                curSize = nf.format(size);
                maxSize = nf.format(max);
                sizeName = "Byte(s)";
            } else if ((double)size < 1048576.0) {
                curSize = nf.format((double)size / 1024.0);
                maxSize = nf.format((double)max / 1024.0);
                sizeName = " KB";
            } else if ((double)size < 1.073741824E9) {
                curSize = nf.format((double)size / 1048576.0);
                maxSize = nf.format((double)max / 1048576.0);
                sizeName = " MB";
            } else {
                curSize = nf.format((double)size / 1.073741824E9);
                maxSize = nf.format((double)max / 1.073741824E9);
                sizeName = " GB";
            }
        }
        catch (Exception e) {
            logger.debug("Error parse size", (Throwable)e);
            curSize = String.valueOf(size);
            maxSize = String.valueOf(max);
            sizeName = " Byte(s)";
        }
        return String.format(BYTES_SIZE, curSize, maxSize, sizeName);
    }

    public static final class View {
        public String name;
        public String currentSize;
        public BigDecimal fullness;
        public int fullnessState;
        public long hits;
        public long miss;
        public BigDecimal usefulness;
        public int usefulnessState;
        public boolean hasStatistic;
        public boolean hasTimeEvict;
    }
}

