/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.ehcache.monitoring.service;

import java.util.Collections;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.CollectionPageService;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.api.FilteredCollectionPage;
import net.n2oapp.framework.config.ehcache.monitoring.CacheTuner;
import net.n2oapp.framework.config.ehcache.monitoring.api.CacheConfig;
import net.n2oapp.framework.config.ehcache.monitoring.api.CacheCriteria;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;

public class CacheConfigService
implements CollectionPageService<CacheCriteria, CacheConfig> {
    private final CacheTuner tuner;

    public CacheConfigService(CacheTuner tuner) {
        this.tuner = tuner;
    }

    public CollectionPage<CacheConfig> getCollectionPage(CacheCriteria cacheCriteria) {
        CacheConfig cacheConfig = this.map(this.tuner.cache(cacheCriteria.name));
        return new FilteredCollectionPage(Collections.singletonList(cacheConfig), (Criteria)cacheCriteria);
    }

    public CacheConfig map(Ehcache ehcache) {
        CacheConfig config = new CacheConfig();
        config.name = ehcache.getName();
        CacheConfiguration configuration = ehcache.getCacheConfiguration();
        config.isFrozen = configuration.isFrozen();
        config.timeToLive = configuration.getTimeToLiveSeconds() != 0L ? Long.valueOf(configuration.getTimeToLiveSeconds()) : null;
        config.timeToIdle = configuration.getTimeToIdleSeconds() != 0L ? Long.valueOf(configuration.getTimeToIdleSeconds()) : null;
        config.maxEntriesLocalHeap = configuration.getMaxEntriesLocalHeap() != 0L ? Long.valueOf(configuration.getMaxEntriesLocalHeap()) : null;
        config.maxEntriesLocalDisk = configuration.getMaxEntriesLocalDisk() != 0L ? Long.valueOf(configuration.getMaxEntriesLocalDisk()) : null;
        config.maxBytesLocalHeap = configuration.getMaxBytesLocalHeap() != 0L ? Long.valueOf(configuration.getMaxBytesLocalHeap()) : null;
        config.maxBytesLocalDisk = configuration.getMaxBytesLocalDisk() != 0L ? Long.valueOf(configuration.getMaxBytesLocalDisk()) : null;
        config.isOverflowToOffHeap = configuration.isOverflowToOffHeap();
        return config;
    }
}

