/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGenerator;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileTransformer;
import net.n2oapp.framework.api.metadata.compile.CompileTransformerFactory;
import net.n2oapp.framework.api.metadata.compile.ExtensionAttributeMapper;
import net.n2oapp.framework.api.metadata.compile.ExtensionAttributeMapperFactory;
import net.n2oapp.framework.api.metadata.compile.MetadataBinder;
import net.n2oapp.framework.api.metadata.compile.SourceCompiler;
import net.n2oapp.framework.api.metadata.compile.SourceMerger;
import net.n2oapp.framework.api.metadata.compile.SourceMergerFactory;
import net.n2oapp.framework.api.metadata.compile.SourceTransformer;
import net.n2oapp.framework.api.metadata.compile.SourceTransformerFactory;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.io.ProxyNamespaceIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersister;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.pipeline.BindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.CompileBindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.CompilePipeline;
import net.n2oapp.framework.api.metadata.pipeline.CompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.PersistTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperation;
import net.n2oapp.framework.api.metadata.pipeline.PipelineSupport;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.SourceValidatorFactory;
import net.n2oapp.framework.api.pack.MetadataPack;
import net.n2oapp.framework.api.pack.PersistersBuilder;
import net.n2oapp.framework.api.pack.ReadersBuilder;
import net.n2oapp.framework.api.reader.SourceLoader;
import net.n2oapp.framework.api.register.DynamicMetadataProvider;
import net.n2oapp.framework.api.register.MetaType;
import net.n2oapp.framework.api.register.MetadataRegister;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.register.route.RouteInfo;
import net.n2oapp.framework.api.register.scan.MetadataScanner;
import net.n2oapp.framework.config.compile.pipeline.N2oEnvironment;
import net.n2oapp.framework.config.compile.pipeline.N2oPipelineSupport;
import net.n2oapp.framework.config.factory.AwareFactorySupport;
import net.n2oapp.framework.config.register.route.N2oRouter;
import net.n2oapp.framework.config.test.SimplePropertyResolver;
import net.n2oapp.properties.OverrideProperties;
import net.n2oapp.properties.reader.PropertiesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertyResolver;

public class N2oApplicationBuilder
implements ReadersBuilder<N2oApplicationBuilder>,
PersistersBuilder<N2oApplicationBuilder>,
PipelineSupport {
    private static final Logger logger = LoggerFactory.getLogger(N2oApplicationBuilder.class);
    private MetadataEnvironment environment;

    public N2oApplicationBuilder() {
        this.environment = new N2oEnvironment();
    }

    public N2oApplicationBuilder(MetadataEnvironment environment) {
        this.environment = environment;
    }

    @SafeVarargs
    public final N2oApplicationBuilder packs(MetadataPack<? super N2oApplicationBuilder> ... packs) {
        Stream.of(packs).forEach(p -> p.build((Object)this));
        return this;
    }

    public N2oApplicationBuilder types(MetaType ... types) {
        this.environment.getSourceTypeRegister().addAll(Arrays.asList(types));
        return this;
    }

    public N2oApplicationBuilder operations(PipelineOperation<?, ?> ... operations) {
        this.environment.getPipelineOperationFactory().add((Object[])operations);
        return this;
    }

    @SafeVarargs
    public final N2oApplicationBuilder readers(NamespaceReader<? extends NamespaceUriAware> ... readers) {
        Stream.of(readers).forEach(arg_0 -> ((NamespaceReaderFactory)this.environment.getNamespaceReaderFactory()).add(arg_0));
        return this;
    }

    @SafeVarargs
    public final N2oApplicationBuilder ios(NamespaceIO<? extends NamespaceUriAware> ... ios) {
        Stream.of(ios).forEach(io -> this.environment.getNamespaceReaderFactory().add((NamespaceReader)new ProxyNamespaceIO(io)));
        Stream.of(ios).forEach(io -> this.environment.getNamespacePersisterFactory().add((NamespacePersister)new ProxyNamespaceIO(io)));
        return this;
    }

    public N2oApplicationBuilder persisters(NamespacePersister<? extends NamespaceUriAware> ... persisters) {
        Stream.of(persisters).forEach(arg_0 -> ((NamespacePersisterFactory)this.environment.getNamespacePersisterFactory()).add(arg_0));
        return this;
    }

    public N2oApplicationBuilder compilers(SourceCompiler<?, ?, ?> ... compilers) {
        this.environment.getSourceCompilerFactory().add((Object[])compilers);
        return this;
    }

    public N2oApplicationBuilder providers(DynamicMetadataProvider ... providers) {
        this.environment.getDynamicMetadataProviderFactory().add((Object[])providers);
        return this;
    }

    public N2oApplicationBuilder binders(MetadataBinder<?> ... binders) {
        this.environment.getMetadataBinderFactory().add((Object[])binders);
        return this;
    }

    public N2oApplicationBuilder scanners(MetadataScanner<?> ... scanners) {
        this.environment.getMetadataScannerFactory().add((Object[])scanners);
        return this;
    }

    public N2oApplicationBuilder loaders(SourceLoader<?> ... loaders) {
        this.environment.getSourceLoaderFactory().add((Object[])loaders);
        return this;
    }

    public N2oApplicationBuilder routes(RouteInfo ... routes) {
        Stream.of(routes).forEach(routeInfo -> this.environment.getRouteRegister().addRoute(routeInfo.getUrlPattern(), routeInfo.getContext()));
        return this;
    }

    public N2oApplicationBuilder sources(SourceInfo ... sources) {
        Stream.of(sources).forEach(arg_0 -> ((MetadataRegister)this.environment.getMetadataRegister()).add(arg_0));
        return this;
    }

    public N2oApplicationBuilder validators(SourceValidator<?> ... validators) {
        Stream.of(validators).forEach(arg_0 -> N2oApplicationBuilder.lambda$validators$4(this.environment.getSourceValidatorFactory(), arg_0));
        return this;
    }

    public N2oApplicationBuilder mergers(SourceMerger<?> ... mergers) {
        Stream.of(mergers).forEach(arg_0 -> N2oApplicationBuilder.lambda$mergers$5(this.environment.getSourceMergerFactory(), arg_0));
        return this;
    }

    public N2oApplicationBuilder transformers(SourceTransformer<?> ... transformers) {
        Stream.of(transformers).forEach(arg_0 -> N2oApplicationBuilder.lambda$transformers$6(this.environment.getSourceTransformerFactory(), arg_0));
        return this;
    }

    public N2oApplicationBuilder transformers(CompileTransformer<?, ?> ... transformers) {
        Stream.of(transformers).forEach(arg_0 -> N2oApplicationBuilder.lambda$transformers$7(this.environment.getCompileTransformerFactory(), arg_0));
        return this;
    }

    public N2oApplicationBuilder extensions(ExtensionAttributeMapper ... extensions) {
        Stream.of(extensions).forEach(arg_0 -> N2oApplicationBuilder.lambda$extensions$8(this.environment.getExtensionAttributeMapperFactory(), arg_0));
        return this;
    }

    public N2oApplicationBuilder generators(ButtonGenerator ... generators) {
        Stream.of(generators).forEach(arg_0 -> N2oApplicationBuilder.lambda$generators$9(this.environment.getButtonGeneratorFactory(), arg_0));
        return this;
    }

    public N2oApplicationBuilder properties(String ... properties) {
        PropertyResolver systemProperties = this.environment.getSystemProperties();
        if (!(systemProperties instanceof SimplePropertyResolver)) {
            throw new IllegalArgumentException("System properties is readonly");
        }
        Stream.of(properties).forEach(p -> {
            String[] split = p.contains("=") ? p.split("=") : p.split(":");
            ((SimplePropertyResolver)systemProperties).setProperty(split[0], split[1]);
        });
        return this;
    }

    public N2oApplicationBuilder propertySources(String ... propertySources) {
        PropertyResolver systemProperties = this.environment.getSystemProperties();
        if (!(systemProperties instanceof SimplePropertyResolver)) {
            throw new IllegalArgumentException("System properties is readonly");
        }
        Properties baseProperties = ((SimplePropertyResolver)systemProperties).getProperties();
        for (String propertySource : propertySources) {
            OverrideProperties properties = PropertiesReader.getPropertiesFromClasspath((String)propertySource);
            properties.setBaseProperties(baseProperties);
            baseProperties = properties;
        }
        ((N2oEnvironment)this.environment).setSystemProperties(new SimplePropertyResolver(baseProperties));
        return this;
    }

    public N2oApplicationBuilder scan() {
        this.build();
        List sources = this.environment.getMetadataScannerFactory().scan();
        this.environment.getMetadataRegister().addAll((Collection)sources);
        logger.info("Scanned " + sources.size() + " metadata");
        return this;
    }

    public ReadTerminalPipeline<ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>> read() {
        this.build();
        return (ReadTerminalPipeline)N2oPipelineSupport.readPipeline(this.environment).read();
    }

    public CompileTerminalPipeline<CompileBindTerminalPipeline> compile() {
        this.build();
        return (CompileTerminalPipeline)N2oPipelineSupport.compilePipeline(this.environment).compile();
    }

    public CompilePipeline merge() {
        this.build();
        return (CompilePipeline)N2oPipelineSupport.compilePipeline(this.environment).merge();
    }

    public BindTerminalPipeline bind() {
        this.build();
        return (BindTerminalPipeline)N2oPipelineSupport.bindPipeline(this.environment).bind();
    }

    public PersistTerminalPipeline persist() {
        this.build();
        return (PersistTerminalPipeline)N2oPipelineSupport.persistPipeline(this.environment).persist();
    }

    public <D extends Compiled> CompileContext<D, ?> route(String url, Class<D> compiledClass, Map<String, String[]> params) {
        this.build();
        return new N2oRouter(this.environment, (ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)this.read().transform()).validate()).cache()).copy()).compile()).transform()).get(url, compiledClass, params);
    }

    public MetadataEnvironment getEnvironment() {
        return this.environment;
    }

    private N2oApplicationBuilder build() {
        AwareFactorySupport.enrich(this.environment.getDynamicMetadataProviderFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getMetadataScannerFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getNamespaceReaderFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getSourceLoaderFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getNamespacePersisterFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getSourceMergerFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getSourceTransformerFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getSourceValidatorFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getSourceCompilerFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getCompileTransformerFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getMetadataBinderFactory(), this.environment);
        AwareFactorySupport.enrich(this.environment.getPipelineOperationFactory(), this.environment);
        return this;
    }

    private static /* synthetic */ void lambda$generators$9(ButtonGeneratorFactory rec$, ButtonGenerator xva$0) {
        rec$.add((Object[])new ButtonGenerator[]{xva$0});
    }

    private static /* synthetic */ void lambda$extensions$8(ExtensionAttributeMapperFactory rec$, ExtensionAttributeMapper xva$0) {
        rec$.add((Object[])new ExtensionAttributeMapper[]{xva$0});
    }

    private static /* synthetic */ void lambda$transformers$7(CompileTransformerFactory rec$, CompileTransformer xva$0) {
        rec$.add((Object[])new CompileTransformer[]{xva$0});
    }

    private static /* synthetic */ void lambda$transformers$6(SourceTransformerFactory rec$, SourceTransformer xva$0) {
        rec$.add((Object[])new SourceTransformer[]{xva$0});
    }

    private static /* synthetic */ void lambda$mergers$5(SourceMergerFactory rec$, SourceMerger xva$0) {
        rec$.add((Object[])new SourceMerger[]{xva$0});
    }

    private static /* synthetic */ void lambda$validators$4(SourceValidatorFactory rec$, SourceValidator xva$0) {
        rec$.add((Object[])new SourceValidator[]{xva$0});
    }
}

