/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.compile.pipeline;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.engine.factory.EngineNotFoundException;
import net.n2oapp.engine.factory.integration.spring.OverrideBean;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.factory.MetadataFactory;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.aware.PipelineOperationTypeAware;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperation;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperationFactory;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperationType;
import net.n2oapp.framework.config.factory.AwareFactorySupport;

public class N2oPipelineOperationFactory
implements MetadataFactory<PipelineOperation>,
PipelineOperationFactory,
MetadataEnvironmentAware {
    private Map<PipelineOperationType, PipelineOperation> enginesMap = new HashMap<PipelineOperationType, PipelineOperation>();

    public N2oPipelineOperationFactory() {
    }

    public N2oPipelineOperationFactory(Map<String, PipelineOperation> beans) {
        this.enginesMap.putAll(OverrideBean.removeOverriddenBeans(beans).values().stream().collect(Collectors.toMap(o -> ((PipelineOperationTypeAware)o).getPipelineOperationType(), o -> o)));
    }

    public PipelineOperation<?, ?> produce(PipelineOperationType type) {
        PipelineOperation operation = this.enginesMap.get(type);
        if (operation == null) {
            throw new EngineNotFoundException((Object)type);
        }
        return operation;
    }

    public MetadataFactory<PipelineOperation> add(PipelineOperation ... g) {
        Stream.of(g).forEach(o -> this.enginesMap.put(((PipelineOperationTypeAware)o).getPipelineOperationType(), (PipelineOperation)o));
        return this;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.enginesMap.values().forEach(o -> AwareFactorySupport.enrich(o, environment));
    }
}

