/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.PlaceHoldersResolver;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.RefIdAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.ExtensionAttributeMapperFactory;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.pipeline.BindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.CompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.config.compile.pipeline.N2oPipelineSupport;
import net.n2oapp.framework.config.metadata.compile.DataModel;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.CompileUtil;

public class N2oCompileProcessor
implements CompileProcessor,
BindProcessor,
ValidateProcessor {
    private static final PlaceHoldersResolver LINK_RESOLVER = new PlaceHoldersResolver("{", "}");
    private static final PlaceHoldersResolver URL_RESOLVER = new PlaceHoldersResolver(":", "", Boolean.valueOf(true));
    private MetadataEnvironment env;
    private SubModelsProcessor subModelsProcessor;
    private Map<Class<?>, Object> scope = Collections.emptyMap();
    private CompileContext<?, ?> context;
    private DataSet params;
    private DataModel model;
    private BindTerminalPipeline bindPipeline;
    private CompileTerminalPipeline<?> compilePipeline;
    private ReadCompileTerminalPipeline<?> readCompilePipeline;
    private ReadTerminalPipeline<?> readPipeline;
    private Set<String> forbiddenIds;

    public N2oCompileProcessor(MetadataEnvironment env) {
        this.env = env;
        N2oPipelineSupport pipelineSupport = new N2oPipelineSupport(env);
        this.bindPipeline = (BindTerminalPipeline)env.getBindPipelineFunction().apply((Object)pipelineSupport);
        this.readPipeline = (ReadTerminalPipeline)env.getReadPipelineFunction().apply((Object)pipelineSupport);
        this.readCompilePipeline = (ReadCompileTerminalPipeline)env.getReadCompilePipelineFunction().apply((Object)pipelineSupport);
        this.compilePipeline = (CompileTerminalPipeline)env.getCompilePipelineFunction().apply((Object)pipelineSupport);
        this.forbiddenIds = (Set)env.getSystemProperties().getProperty("n2o.config.field.forbidden_ids", Set.class);
    }

    public N2oCompileProcessor(MetadataEnvironment env, CompileContext<?, ?> context, DataSet params) {
        this(env);
        this.context = context;
        this.params = params;
        this.model = new DataModel();
        this.model.addAll(context.getQueryRouteMapping(), params);
        this.model.addAll(context.getPathRouteMapping(), params);
    }

    public N2oCompileProcessor(MetadataEnvironment env, CompileContext<?, ?> context, DataSet params, SubModelsProcessor subModelsProcessor) {
        this(env);
        this.context = context;
        this.params = params;
        this.subModelsProcessor = subModelsProcessor;
        this.model = new DataModel();
        this.model.addAll(context.getQueryRouteMapping(), params);
        this.model.addAll(context.getPathRouteMapping(), params);
    }

    private N2oCompileProcessor(N2oCompileProcessor parent, Object ... scopes) {
        this.env = parent.env;
        this.scope = new HashMap(parent.scope);
        Stream.of(Optional.ofNullable(scopes).orElse(new Compiled[0])).filter(Objects::nonNull).forEach(s -> this.scope.put(s.getClass(), s));
        this.readPipeline = parent.readPipeline;
        this.readCompilePipeline = parent.readCompilePipeline;
        this.compilePipeline = parent.compilePipeline;
        this.params = parent.params;
        this.context = parent.context;
        this.forbiddenIds = parent.forbiddenIds;
    }

    public <D extends Compiled, S> D compile(S source, CompileContext<?, ?> context, Object ... scopes) {
        Object[] flattedScopes = Arrays.stream(scopes).filter(Objects::nonNull).flatMap(o -> o.getClass().isArray() ? Arrays.stream((Object[])o) : Stream.of(o)).toArray();
        return (D)this.compilePipeline.get(source, context, (CompileProcessor)new N2oCompileProcessor(this, flattedScopes));
    }

    public <D extends Compiled> void bind(D compiled) {
        if (compiled != null) {
            this.bindPipeline.get(compiled, this.context, this.params, this.subModelsProcessor);
        }
    }

    public Map<String, Object> mapAttributes(ExtensionAttributesAware source) {
        if (source.getExtAttributes() == null || source.getExtAttributes().isEmpty()) {
            return null;
        }
        ExtensionAttributeMapperFactory extensionAttributeMapperFactory = this.env.getExtensionAttributeMapperFactory();
        HashMap<String, Object> extAttributes = new HashMap<String, Object>();
        source.getExtAttributes().forEach((k, v) -> {
            Map<String, Object> res = extensionAttributeMapperFactory.mapAttributes(v, k.getUri());
            if (!(res = CompileUtil.resolveNestedAttributes(res, arg_0 -> ((DomainProcessor)this.env.getDomainProcessor()).deserialize(arg_0))).isEmpty()) {
                extAttributes.putAll(res);
            }
        });
        return extAttributes;
    }

    public <D extends Compiled> D getCompiled(CompileContext<D, ?> context) {
        return (D)this.readCompilePipeline.get(context, (CompileProcessor)new N2oCompileProcessor(this, new Object[0]));
    }

    public <D> D getScope(Class<D> scopeClass) {
        return (D)this.scope.get(scopeClass);
    }

    public <S extends SourceMetadata> S getSource(String id, Class<S> sourceClass) {
        return (S)this.readPipeline.get(id, sourceClass);
    }

    public <D extends Compiled> void addRoute(CompileContext<D, ?> context) {
        this.env.getRouteRegister().addRoute(context.getRoute((BindProcessor)this), context);
    }

    public <D extends Compiled> void addRoute(String route, CompileContext<D, ?> context) {
        this.env.getRouteRegister().addRoute(route, context);
    }

    public <T> T resolve(String placeholder, Class<T> clazz) {
        Object value = this.resolveRequiredPlaceholder(placeholder);
        return (T)this.env.getDomainProcessor().deserialize(value, clazz);
    }

    public Object resolve(String placeholder, String domain) {
        Object value = this.resolveRequiredPlaceholder(placeholder);
        return this.env.getDomainProcessor().deserialize(value, domain);
    }

    public Object resolve(String placeholder) {
        Object value = this.resolvePlaceholder(placeholder);
        return this.env.getDomainProcessor().deserialize(value);
    }

    public String resolveText(String text) {
        if (StringUtils.hasProperty((String)text)) {
            return this.env.getSystemProperties().resolvePlaceholders(text);
        }
        if (StringUtils.hasContext((String)text)) {
            return this.env.getContextProcessor().resolveText(text);
        }
        return text;
    }

    public String getMessage(String messageCode, Object ... arguments) {
        String defaultMessage = messageCode.contains("{0}") ? MessageFormat.format(messageCode, arguments) : messageCode;
        return this.env.getMessageSource().getMessage(messageCode, arguments, defaultMessage);
    }

    public <S extends Source> S merge(S source, S override) {
        return (S)((Source)this.env.getSourceMergerFactory().merge(source, override));
    }

    public boolean canResolveParam(String param) {
        return this.params != null && this.params.containsKey((Object)param);
    }

    public Object resolveJS(String text, Class<?> clazz) {
        String value = ScriptProcessor.resolveLinks((String)text);
        return this.env.getDomainProcessor().deserialize((Object)value, clazz);
    }

    public String resolveUrl(String url) {
        return URL_RESOLVER.resolve(url, (Object)this.params);
    }

    public String resolveUrl(String url, Map<String, ? extends BindLink> pathMappings, Map<String, ? extends BindLink> queryMappings) {
        String resultUrl = url;
        if (pathMappings != null) {
            resultUrl = URL_RESOLVER.resolve(resultUrl, k -> this.getValue(pathMappings, (String)k));
        }
        if (queryMappings != null) {
            resultUrl = URL_RESOLVER.resolve(resultUrl, k -> this.getValue(queryMappings, (String)k));
        }
        resultUrl = URL_RESOLVER.resolve(resultUrl, (Object)this.params);
        return resultUrl;
    }

    public String resolveUrl(String url, ModelLink link) {
        List<String> paramNames = RouteUtil.getParams(url);
        if (paramNames.isEmpty() || this.params == null) {
            return url;
        }
        HashMap<String, String> valueParamMap = new HashMap<String, String>();
        this.collectModelLinks(this.context.getPathRouteMapping(), link.getWidgetLink(), valueParamMap);
        this.collectModelLinks(this.context.getQueryRouteMapping(), link.getWidgetLink(), valueParamMap);
        for (String param : paramNames) {
            if (!valueParamMap.containsKey(param) || !this.params.containsKey(valueParamMap.get(param))) continue;
            url = url.replace(":" + param, this.params.get(valueParamMap.get(param)).toString());
        }
        return url;
    }

    public BindLink resolveLink(BindLink link) {
        Object value;
        BindLink resultLink;
        if (link == null || this.context == null) {
            return link;
        }
        Optional<Object> res = Optional.empty();
        if (this.context.getQueryRouteMapping() != null) {
            res = this.context.getQueryRouteMapping().keySet().stream().filter(ri -> ((ModelLink)this.context.getQueryRouteMapping().get(ri)).equals((Object)link)).findAny();
        }
        if (!res.isPresent() && this.context.getPathRouteMapping() != null) {
            res = this.context.getPathRouteMapping().keySet().stream().filter(ri -> ((ModelLink)this.context.getPathRouteMapping().get(ri)).equals((Object)link)).findAny();
        }
        if (res.isPresent() && (resultLink = this.createLink(link, value = this.params.get(res.get()))) != null) {
            return resultLink;
        }
        if (link instanceof ModelLink && ((ModelLink)link).getParam() != null && (resultLink = this.createLink(link, value = this.params.get((Object)((ModelLink)link).getParam()))) != null) {
            return resultLink;
        }
        return link;
    }

    public Object getLinkValue(ModelLink link) {
        return link.getParam() != null ? this.params.get((Object)link.getParam()) : null;
    }

    private BindLink createLink(BindLink link, Object value) {
        if (value instanceof String) {
            value = this.resolveText((String)value);
        }
        if (value != null) {
            ModelLink resultLink = link instanceof ModelLink ? new ModelLink((ModelLink)link) : new BindLink(link.getBindLink());
            resultLink.setValue(value);
            return resultLink;
        }
        return null;
    }

    public void resolveSubModels(ModelLink link) {
        if (link.getSubModelQuery() == null) {
            return;
        }
        this.resolveDefaultValues(link);
        this.executeSubModels(link);
    }

    public void resolveFiltersModels(String filtersDefaultValuesQueryId, List<Filter> filters) {
        if (this.subModelsProcessor == null) {
            return;
        }
        DataSet queryResult = (DataSet)((List)this.subModelsProcessor.getQueryResult(filtersDefaultValuesQueryId).getCollection()).get(0);
        for (Filter filter : filters) {
            Object value = queryResult.get((Object)filter.getFilterId());
            if (value == null) continue;
            ModelLink link = new ModelLink(filter.getLink());
            link.setValue(value);
            filter.setLink(link);
        }
    }

    public String resolveText(String text, ModelLink link) {
        String resolved = this.resolveText(text);
        if (link != null) {
            return LINK_RESOLVER.resolve(resolved, this.model.getDataIfAbsent(link, this.subModelsProcessor));
        }
        return resolved;
    }

    public <T extends Source> void validate(T metadata, Object ... scope) {
        if (metadata == null) {
            return;
        }
        if (metadata instanceof RefIdAware && ((RefIdAware)metadata).getRefId() != null) {
            return;
        }
        this.env.getSourceValidatorFactory().validate(metadata, (ValidateProcessor)new N2oCompileProcessor(this, scope));
    }

    public <T extends SourceMetadata> T getOrNull(String id, Class<T> metadataClass) {
        if (id == null) {
            return null;
        }
        if (!this.env.getMetadataRegister().contains(id, metadataClass)) {
            return null;
        }
        try {
            return this.getSource(id, metadataClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T extends SourceMetadata> T getOrThrow(String id, Class<T> metadataClass) {
        if (id == null) {
            return null;
        }
        if (!this.env.getMetadataRegister().contains(id, metadataClass)) {
            return null;
        }
        return this.getSource(id, metadataClass);
    }

    public <T extends SourceMetadata> void checkForExists(String id, Class<T> metadataClass, String errorMessage) {
        if (id == null) {
            return;
        }
        if (StringUtils.hasWildcard((String)id) || StringUtils.hasLink((String)id)) {
            return;
        }
        if (!this.env.getMetadataRegister().contains(id, metadataClass)) {
            throw new N2oMetadataValidationException(this.getMessage(errorMessage, id));
        }
    }

    public void checkId(IdAware metadata, String errorMessage) {
        if (metadata == null || metadata.getId() == null) {
            return;
        }
        Pattern pattern = Pattern.compile(".*[\u0430-\u044f\u0410-\u042f\u0451\u0401].*");
        Matcher matcher = pattern.matcher(metadata.getId());
        if (matcher.find() || this.forbiddenIds.contains(metadata.getId())) {
            throw new N2oMetadataValidationException(this.getMessage(errorMessage, metadata.getId()));
        }
    }

    private Object resolvePlaceholder(String placeholder) {
        String value = placeholder;
        if (StringUtils.isProperty((String)placeholder)) {
            value = this.env.getSystemProperties().resolvePlaceholders(placeholder);
        }
        return value;
    }

    private Object resolveRequiredPlaceholder(String placeholder) {
        if (StringUtils.isProperty((String)placeholder)) {
            return this.env.getSystemProperties().resolveRequiredPlaceholders(placeholder);
        }
        return placeholder;
    }

    private void collectModelLinks(Map<String, ModelLink> linkMap, ModelLink link, Map<String, String> resultMap) {
        if (linkMap != null) {
            linkMap.forEach((k, v) -> {
                if (v.equalsLink((Object)link)) {
                    resultMap.put((String)k, (String)k);
                    resultMap.put(v.getFieldId(), (String)k);
                }
            });
        }
    }

    private void executeSubModels(ModelLink link) {
        if (link.getValue() == null || link.getSubModelQuery().getSubModel() == null) {
            return;
        }
        if (link.getValue() instanceof List) {
            for (DefaultValues defaultValues : (List)link.getValue()) {
                DataSet dataSet = new DataSet();
                dataSet.put(link.getSubModelQuery().getSubModel(), (Object)defaultValues.getValues());
                if (this.subModelsProcessor != null) {
                    this.subModelsProcessor.executeSubModels(Collections.singletonList(link.getSubModelQuery()), dataSet);
                }
                defaultValues.setValues((Map)dataSet.get((Object)link.getSubModelQuery().getSubModel()));
            }
        } else if (link.getValue() instanceof DefaultValues) {
            DataSet dataSet = new DataSet();
            dataSet.put(link.getSubModelQuery().getSubModel(), (Object)((DefaultValues)link.getValue()).getValues());
            if (this.subModelsProcessor != null) {
                this.subModelsProcessor.executeSubModels(Collections.singletonList(link.getSubModelQuery()), dataSet);
            }
            ((DefaultValues)link.getValue()).setValues((Map)dataSet.get((Object)link.getSubModelQuery().getSubModel()));
        }
    }

    private void resolveDefaultValues(ModelLink link) {
        if (link.getSubModelQuery().getValueFieldId() == null) {
            return;
        }
        if (link.getParam() != null && this.params.containsKey((Object)link.getParam())) {
            if (this.params.get((Object)link.getParam()) instanceof List) {
                ArrayList<DefaultValues> values = new ArrayList<DefaultValues>();
                for (Object value : (List)this.params.get((Object)link.getParam())) {
                    DefaultValues defaultValues = new DefaultValues();
                    defaultValues.setValues(new HashMap());
                    defaultValues.getValues().put(link.getSubModelQuery().getValueFieldId(), value);
                    values.add(defaultValues);
                }
                if (!values.isEmpty()) {
                    link.setValue(values);
                }
            } else {
                DefaultValues defaultValues = new DefaultValues();
                defaultValues.setValues(new HashMap());
                defaultValues.getValues().put(link.getSubModelQuery().getValueFieldId(), this.params.get((Object)link.getParam()));
                link.setValue((Object)(link.getSubModelQuery().getMulti() != null && link.getSubModelQuery().getMulti() != false ? Collections.singletonList(defaultValues) : defaultValues));
            }
        }
    }

    private Object getValue(Map<String, ? extends BindLink> mapping, String key) {
        if (!mapping.containsKey(key)) {
            return null;
        }
        BindLink bindLink = mapping.get(key);
        if (bindLink instanceof ModelLink) {
            Object value = this.model.getValue((ModelLink)bindLink);
            if (value != null) {
                mapping.remove(key);
            }
            return value;
        }
        return null;
    }
}

