/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.DynamicUtil;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.WidgetIdAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public abstract class AbstractOpenPageCompiler<D extends Action, S extends N2oAbstractPageAction>
extends AbstractActionCompiler<D, S> {
    protected List<N2oPreFilter> initPreFilters(N2oAbstractPageAction source, String actionRoute, String parentWidgetId, CompileProcessor p) {
        WidgetIdAware widgetIdAware;
        ArrayList<N2oPreFilter> preFilters = new ArrayList<N2oPreFilter>();
        ReduxModel model = this.getTargetWidgetModel(p, ReduxModel.RESOLVE);
        String widgetId = parentWidgetId;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (widgetIdAware = componentScope.unwrap(WidgetIdAware.class)) != null && widgetIdAware.getWidgetId() != null) {
            widgetId = widgetIdAware.getWidgetId();
        }
        if (source.getDetailFieldId() != null) {
            N2oPreFilter filter = new N2oPreFilter();
            filter.setFieldId((String)p.cast((Object)source.getDetailFieldId(), (Object)"id", new Object[0]));
            filter.setType(FilterType.eq);
            filter.setValueAttr(Placeholders.ref((String)((String)p.cast((Object)source.getMasterFieldId(), (Object)"id", new Object[0]))));
            filter.setRefWidgetId(widgetId);
            if ((source.getMasterFieldId() == null || source.getMasterFieldId().equals("id")) && ReduxModel.RESOLVE.equals((Object)model)) {
                List<String> actionRouteParams = RouteUtil.getParams(actionRoute);
                String masterIdParam = actionRouteParams.isEmpty() ? null : actionRouteParams.get(0);
                filter.setParam((String)p.cast((Object)source.getMasterParam(), (Object)masterIdParam, new Object[]{this.createGlobalParam(filter.getFieldId(), p)}));
            } else {
                filter.setParam((String)p.cast((Object)source.getMasterParam(), (Object)this.createGlobalParam(filter.getFieldId(), p), new Object[0]));
            }
            filter.setRefModel(ReduxModel.RESOLVE);
            PageScope pageScope = (PageScope)p.getScope(PageScope.class);
            if (pageScope != null) {
                filter.setRefPageId(pageScope.getPageId());
            }
            preFilters.add(filter);
        }
        if (source.getPreFilters() != null) {
            for (N2oPreFilter preFilter : source.getPreFilters()) {
                N2oPreFilter filter = new N2oPreFilter();
                filter.setFieldId(preFilter.getFieldId());
                filter.setParam((String)p.cast((Object)preFilter.getParam(), (Object)this.createGlobalParam(filter.getFieldId(), p), new Object[0]));
                filter.setType(preFilter.getType());
                filter.setValueAttr(preFilter.getValueAttr());
                filter.setValuesAttr(preFilter.getValuesAttr());
                filter.setRefWidgetId((String)p.cast((Object)preFilter.getRefWidgetId(), (Object)widgetId, new Object[0]));
                filter.setRefModel((ReduxModel)p.cast((Object)preFilter.getRefModel(), (Object)model, new Object[0]));
                PageScope pageScope = (PageScope)p.getScope(PageScope.class);
                if (pageScope != null) {
                    filter.setRefPageId(pageScope.getPageId());
                }
                preFilters.add(filter);
            }
        }
        return preFilters;
    }

    protected abstract PageContext constructContext(String var1, String var2);

    protected PageContext initPageContext(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
        List<String> pathParams;
        ComponentScope componentScope;
        ModelLink actionModelLink;
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        this.validatePathAndRoute(source.getRoute(), source.getPathParams(), routeScope);
        String pageId = source.getPageId();
        ReduxModel actionDataModel = this.getTargetWidgetModel(p, ReduxModel.RESOLVE);
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String route = (String)p.cast((Object)(routeScope != null ? routeScope.getUrl() : null), (Object)context.getRoute((BindProcessor)((N2oCompileProcessor)p)), new Object[]{""});
        StrictMap pathMapping = new StrictMap();
        StrictMap queryMapping = new StrictMap();
        if (routeScope != null) {
            pathMapping.putAll(routeScope.getPathMapping());
            queryMapping.putAll(routeScope.getQueryMapping());
        }
        String currentClientWidgetId = null;
        String currentWidgetId = null;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            currentClientWidgetId = widgetScope.getClientWidgetId();
            currentWidgetId = widgetScope.getWidgetId();
        }
        if ((actionModelLink = this.createActionModelLink(actionDataModel, currentClientWidgetId, pageScope, componentScope = (ComponentScope)p.getScope(ComponentScope.class))) == null) {
            throw new N2oException("widget-id for action " + source.getId() + " not specified");
        }
        if (currentClientWidgetId == null) {
            currentClientWidgetId = actionModelLink.getWidgetId();
        }
        String actionRoute = this.initActionRoute(source, actionModelLink, (Map<String, ModelLink>)pathMapping);
        String parentComponentWidgetId = null;
        WidgetIdAware widgetIdAware = componentScope.unwrap(WidgetIdAware.class);
        if (widgetIdAware != null && widgetIdAware.getWidgetId() != null) {
            parentComponentWidgetId = widgetIdAware.getWidgetId();
        }
        String actionModelWidgetId = (String)p.cast((Object)parentComponentWidgetId, (Object)currentWidgetId, new Object[0]);
        Map<String, String> widgetIdQueryIdMap = null;
        if (pageScope != null && !CollectionUtils.isEmpty(pageScope.getWidgetIdQueryIdMap())) {
            widgetIdQueryIdMap = pageScope.getWidgetIdQueryIdMap();
        }
        this.initPathMapping(source.getPathParams(), actionDataModel, (Map<String, ModelLink>)pathMapping, pageScope, actionModelWidgetId, widgetIdQueryIdMap, p);
        String parentRoute = RouteUtil.normalize(route);
        if (widgetScope != null && Boolean.TRUE.equals(widgetScope.getHasIdInParentRoute()) && !(pathParams = RouteUtil.getPathParams(actionRoute)).isEmpty()) {
            parentRoute = RouteUtil.normalize(parentRoute + "/:" + pathParams.get(0));
        }
        route = RouteUtil.normalize(route + actionRoute);
        PageContext pageContext = this.constructContext(pageId, route);
        pageContext.setPageName(source.getPageName());
        pageContext.setBreadcrumbs((List)p.getScope(BreadcrumbList.class));
        pageContext.setSubmitOperationId(source.getSubmitOperationId());
        pageContext.setSubmitLabel(source.getSubmitLabel());
        pageContext.setSubmitModel(source.getSubmitModel());
        pageContext.setSubmitActionType(source.getSubmitActionType());
        pageContext.setCopyModel(source.getCopyModel());
        pageContext.setCopyWidgetId(source.getCopyWidgetId());
        pageContext.setCopyFieldId(source.getCopyFieldId());
        pageContext.setTargetModel(source.getTargetModel());
        pageContext.setTargetWidgetId(source.getTargetWidgetId());
        pageContext.setTargetFieldId(source.getTargetFieldId());
        pageContext.setCopyMode(source.getCopyMode());
        pageContext.setResultWidgetId(source.getResultContainerId());
        pageContext.setUpload(source.getUpload());
        String parentWidgetId = this.initWidgetId(p);
        pageContext.setParentWidgetId(parentWidgetId);
        pageContext.setParentClientWidgetId(currentClientWidgetId);
        pageContext.setParentClientPageId(pageScope != null ? pageScope.getPageId() : null);
        pageContext.setParentModelLink(actionModelLink);
        pageContext.setParentRoute(RouteUtil.addQueryParams(parentRoute, (Map<String, ModelLink>)queryMapping));
        pageContext.setCloseOnSuccessSubmit((Boolean)p.cast((Object)source.getCloseAfterSubmit(), (Object)true, new Object[0]));
        pageContext.setRefreshOnSuccessSubmit((Boolean)p.cast((Object)source.getRefreshAfterSubmit(), (Object)true, new Object[0]));
        if (source.getRefreshWidgetId() != null && pageScope != null) {
            pageContext.setRefreshClientWidgetId(pageScope.getGlobalWidgetId(source.getRefreshWidgetId()));
        }
        pageContext.setRefreshOnClose((Boolean)p.cast((Object)source.getRefreshOnClose(), (Object)false, new Object[0]));
        pageContext.setUnsavedDataPromptOnClose((Boolean)p.cast((Object)source.getUnsavedDataPromptOnClose(), (Object)true, new Object[0]));
        if (source.getSubmitOperationId() != null && source.getRedirectUrlAfterSubmit() == null && Boolean.TRUE.equals(source.getFocusAfterSubmit())) {
            pageContext.setRedirectUrlOnSuccessSubmit(routeScope != null ? RouteUtil.normalize(routeScope.getUrl() + RouteUtil.normalize(Placeholders.colon((String)"id"))) : null);
            pageContext.setRedirectTargetOnSuccessSubmit(Target.application);
        } else if (source.getRedirectUrlAfterSubmit() != null) {
            pageContext.setRedirectUrlOnSuccessSubmit(source.getRedirectUrlAfterSubmit());
            pageContext.setRedirectTargetOnSuccessSubmit((Target)p.cast((Object)source.getRedirectTargetAfterSubmit(), (Object)(RouteUtil.isApplicationUrl(source.getRedirectUrlAfterSubmit()) ? Target.application : Target.self), new Object[0]));
        }
        List<N2oPreFilter> preFilters = this.initPreFilters((N2oAbstractPageAction)source, actionRoute, parentWidgetId, p);
        pageContext.setPreFilters(preFilters);
        pageContext.setPathRouteMapping((Map<String, ModelLink>)pathMapping);
        if (source.getRoute() == null && !ReduxModel.FILTER.equals((Object)actionDataModel)) {
            queryMapping.putAll(this.initPreFilterParams(preFilters, (Map<String, ModelLink>)pathMapping));
        }
        this.initQueryMapping(source.getQueryParams(), actionDataModel, (Map<String, ModelLink>)pathMapping, (Map<String, ModelLink>)queryMapping, pageScope, actionModelWidgetId, widgetIdQueryIdMap, p);
        pageContext.setQueryRouteMapping((Map<String, ModelLink>)queryMapping);
        this.initPageRoute(compiled, route, (Map<String, ModelLink>)pathMapping, (Map<String, ModelLink>)queryMapping);
        this.initOtherPageRoute(p, context, route);
        p.addRoute((CompileContext)pageContext);
        return pageContext;
    }

    private ModelLink createActionModelLink(ReduxModel actionDataModel, String clientWidgetId, PageScope pageScope, ComponentScope componentScope) {
        if (componentScope != null) {
            WidgetIdAware widgetIdAware = componentScope.unwrap(WidgetIdAware.class);
            String actionDataModelClientWidgetId = null;
            actionDataModelClientWidgetId = widgetIdAware != null && widgetIdAware.getWidgetId() != null ? pageScope.getGlobalWidgetId(widgetIdAware.getWidgetId()) : clientWidgetId;
            if (actionDataModel != null && actionDataModelClientWidgetId != null) {
                return new ModelLink(actionDataModel, actionDataModelClientWidgetId, "id");
            }
        }
        return null;
    }

    private void initPathMapping(N2oParam[] params, ReduxModel actionDataModel, Map<String, ModelLink> pathMapping, PageScope pageScope, String defaultParamRefWidgetId, Map<String, String> widgetIdQueryIdMap, CompileProcessor p) {
        if (params == null || params.length == 0) {
            return;
        }
        List<N2oParam> resultParams = this.prepareParams(params, actionDataModel, pageScope, defaultParamRefWidgetId, p);
        pathMapping.putAll(this.initParams(resultParams, pathMapping, widgetIdQueryIdMap));
    }

    private void initQueryMapping(N2oParam[] params, ReduxModel actionDataModel, Map<String, ModelLink> pathMapping, Map<String, ModelLink> queryMapping, PageScope pageScope, String defaultParamRefWidgetId, Map<String, String> widgetIdQueryIdMap, CompileProcessor p) {
        if (params == null || params.length == 0) {
            return;
        }
        List<N2oParam> resultParams = this.prepareParams(params, actionDataModel, pageScope, defaultParamRefWidgetId, p);
        queryMapping.putAll(this.initParams(resultParams, pathMapping, widgetIdQueryIdMap));
    }

    private List<N2oParam> prepareParams(N2oParam[] params, ReduxModel actionDataModel, PageScope pageScope, String defaultParamRefWidgetId, CompileProcessor p) {
        ArrayList<N2oParam> resultParams = new ArrayList<N2oParam>();
        for (N2oParam param : params) {
            String widgetId = (String)p.cast((Object)param.getRefWidgetId(), (Object)defaultParamRefWidgetId, new Object[0]);
            resultParams.add(new N2oParam(param.getName(), param.getValue(), widgetId, (ReduxModel)p.cast((Object)param.getRefModel(), (Object)actionDataModel, new Object[0]), pageScope == null ? null : pageScope.getPageId()));
        }
        return resultParams;
    }

    private Map<String, ModelLink> initParams(List<N2oParam> params, Map<String, ModelLink> pathParams, Map<String, String> widgetIdQueryIdMap) {
        return params == null ? null : params.stream().filter(f -> f.getName() != null && !pathParams.containsKey(f.getName())).collect(Collectors.toMap(N2oParam::getName, param -> {
            String widgetId = param.getRefWidgetId();
            ModelLink link = Redux.linkParam(param);
            if (ReduxModel.RESOLVE.equals((Object)link.getModel()) && widgetIdQueryIdMap != null && widgetIdQueryIdMap.get(widgetId) != null) {
                link.setSubModelQuery(new SubModelQuery((String)widgetIdQueryIdMap.get(widgetId)));
            }
            return link;
        }));
    }

    private String initActionRoute(S source, ModelLink actionModelLink, Map<String, ModelLink> pathMapping) {
        String actionRoute = source.getRoute();
        if (actionRoute == null) {
            boolean isDynamicPage;
            actionRoute = RouteUtil.normalize(source.getId());
            boolean bl = isDynamicPage = DynamicUtil.hasRefs((String)source.getPageId()) || DynamicUtil.isDynamic((String)source.getPageId());
            if (isDynamicPage && actionModelLink != null && ReduxModel.RESOLVE.equals((Object)actionModelLink.getModel())) {
                String masterIdParam = actionModelLink.getWidgetId() + "_id";
                String dynamicPageActionRoute = RouteUtil.normalize(Placeholders.colon((String)masterIdParam)) + actionRoute;
                pathMapping.put(masterIdParam, actionModelLink);
                return dynamicPageActionRoute;
            }
        }
        return actionRoute;
    }

    protected abstract void initPageRoute(D var1, String var2, Map<String, ModelLink> var3, Map<String, ModelLink> var4);

    private void initOtherPageRoute(CompileProcessor p, CompileContext<?, ?> context, String route) {
        if (context instanceof ModalPageContext) {
            return;
        }
        PageRoutes pageRoutes = (PageRoutes)p.getScope(PageRoutes.class);
        if (pageRoutes != null) {
            PageRoutes.Route pageRoute = new PageRoutes.Route(route);
            pageRoute.setIsOtherPage(Boolean.valueOf(true));
            pageRoutes.addRoute(pageRoute);
        }
    }

    private Map<String, ModelLink> initPreFilterParams(List<N2oPreFilter> preFilters, Map<String, ModelLink> pathParams) {
        return preFilters == null ? null : preFilters.stream().filter(f -> f.getParam() != null && !pathParams.containsKey(f.getParam())).collect(Collectors.toMap(N2oPreFilter::getParam, Redux::linkParam));
    }

    private String createGlobalParam(String param, CompileProcessor p) {
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope == null || widgetScope.getClientWidgetId() == null) {
            return param;
        }
        return widgetScope.getClientWidgetId() + "_" + param;
    }

    private String initWidgetId(CompileProcessor p) {
        WidgetIdAware widgetIdAware;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            return widgetScope.getWidgetId();
        }
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (widgetIdAware = componentScope.unwrap(WidgetIdAware.class)) != null && widgetIdAware.getWidgetId() != null) {
            return widgetIdAware.getWidgetId();
        }
        return null;
    }

    protected void validatePathAndRoute(String route, N2oParam[] pathParams, ParentRouteScope routeScope) {
        List<String> routeParams;
        List<String> list = routeParams = route == null ? null : RouteUtil.getParams(route);
        if (!(routeParams != null && !routeParams.isEmpty() || pathParams != null && pathParams.length != 0)) {
            return;
        }
        if (routeParams == null) {
            throw new N2oException(String.format("path-param \"%s\" not used in route", pathParams[0].getName()));
        }
        if (pathParams == null) {
            throw new N2oException(String.format("path-param \"%s\" for route \"%s\" not set", routeParams.get(0), route));
        }
        for (N2oParam pathParam : pathParams) {
            if (!routeParams.contains(pathParam.getName())) {
                throw new N2oException(String.format("route \"%s\" not contains path-param \"%s\"", route, pathParam.getName()));
            }
            if (routeScope == null || routeScope.getUrl() == null || !RouteUtil.getParams(routeScope.getUrl()).contains(pathParam.getName())) continue;
            throw new N2oException(String.format("param \"%s\" duplicate in parent url ", pathParam.getName()));
        }
    }
}

