/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.BuildProcessor;
import net.n2oapp.framework.api.metadata.compile.building.CompileBuilder;
import net.n2oapp.framework.api.metadata.compile.building.CompileConstructor;
import net.n2oapp.framework.api.metadata.compile.building.CompileMapper;
import net.n2oapp.framework.api.metadata.compile.building.FieldBuildProcessor;
import net.n2oapp.framework.api.metadata.compile.building.PluralFieldBuildProcessor;
import net.n2oapp.framework.config.metadata.compile.CompileException;

public class N2oBuildProcessor<O, I>
implements BuildProcessor<O, I> {
    private final Class<O> compiledClass;
    private final Class<I> sourceClass;
    private List<ClassOperation<O, I>> operations;
    private boolean fail;

    public static <D extends Compiled, S> N2oBuildProcessor<D, S> of(Class<D> compiledClass, Class<S> sourceClass) {
        return new N2oBuildProcessor<D, S>(compiledClass, sourceClass);
    }

    public N2oBuildProcessor(Class<O> compiledClass, Class<I> sourceClass) {
        this.compiledClass = compiledClass;
        this.sourceClass = sourceClass;
    }

    private N2oBuildProcessor(N2oBuildProcessor<?, ?> b, boolean fail) {
        this.compiledClass = b.compiledClass;
        this.sourceClass = b.sourceClass;
        this.fail = fail;
    }

    public N2oBuildProcessor<O, I> compile(CompileBuilder<O, I> builder) {
        builder.build((BuildProcessor)this);
        return this;
    }

    public N2oBuildProcessor<O, I> map(CompileMapper<O, I> mapper) {
        return this.addClassOp((d, s, c, p) -> mapper.map(s, d));
    }

    public <T> N2oBuildProcessor<T, T> optionalCast(Class<T> clazz) {
        if (!clazz.isAssignableFrom(this.sourceClass) || !clazz.isAssignableFrom(this.compiledClass)) {
            return new N2oBuildProcessor<O, I>(this, true);
        }
        return this;
    }

    public <T> N2oBuildProcessor<T, T> cast(Class<T> clazz) {
        if (!clazz.isAssignableFrom(this.sourceClass) || !clazz.isAssignableFrom(this.compiledClass)) {
            throw new CompileException("Can't cast " + this.sourceClass + " or " + this.compiledClass + " to " + clazz);
        }
        return this;
    }

    public <T> FieldBuildProcessor<O, I, T> get(Function<I, ? extends T> getter) {
        return this.addFieldOp(new FieldCompileBuilderImpl(getter));
    }

    public <T> PluralFieldBuildProcessor<O, I, T, ?> getArray(Function<I, ? extends T[]> getter) {
        return this.addArrayFieldOp(new CompileArrayFieldBuilder(getter));
    }

    public <T> PluralFieldBuildProcessor<O, I, T, ?> getList(Function<I, List<? extends T>> listGetter) {
        return null;
    }

    public N2oBuildProcessor route() {
        return this;
    }

    public O build(O compiled, I source, CompileContext<?, ?> context, CompileProcessor processor) {
        if (this.fail) {
            return compiled;
        }
        if (this.operations != null) {
            this.operations.forEach(f -> f.handle(compiled, source, context, processor));
        }
        return compiled;
    }

    private <T> FieldBuildProcessor<O, I, T> addFieldOp(FieldCompileBuilderImpl<O, I, T> fieldOperations) {
        this.addClassOp(fieldOperations);
        return fieldOperations;
    }

    private <T, R> CompileArrayFieldBuilder<O, I, T, R> addArrayFieldOp(CompileArrayFieldBuilder<O, I, T, R> fieldOperations) {
        this.addClassOp(fieldOperations);
        return fieldOperations;
    }

    private N2oBuildProcessor<O, I> addClassOp(ClassOperation<O, I> op) {
        if (this.operations == null) {
            this.operations = new ArrayList<ClassOperation<O, I>>();
        }
        this.operations.add(op);
        return this;
    }

    static interface ClassOperation<O, I> {
        public void handle(O var1, I var2, CompileContext<?, ?> var3, CompileProcessor var4);
    }

    static interface FieldOperation<D, S, T, R> {
        public R handle(T var1, D var2, S var3, CompileContext<?, ?> var4, CompileProcessor var5);
    }

    public static class CompileArrayFieldBuilder<D, S, T, L>
    implements ClassOperation<D, S>,
    PluralFieldBuildProcessor<D, S, T, L> {
        private Function<S, ? extends T[]> arrayGetter;
        private BiConsumer<D, ? super L> listSetter;
        private List<FieldOperation<D, S, T, T>> operations;
        private Collector<T, L, L> collector;

        CompileArrayFieldBuilder(Function<S, ? extends T[]> getter) {
            this.arrayGetter = getter;
        }

        public void set(BiConsumer<D, ? super L> listSetter) {
            this.listSetter = listSetter;
        }

        public PluralFieldBuildProcessor<D, S, T, L> collect(Collector<T, ?, L> collector) {
            if (this.collector != null) {
                throw new IllegalStateException("Can't call collector twice");
            }
            this.collector = collector;
            return this;
        }

        public <R> PluralFieldBuildProcessor<D, S, R, L> map(Function<T, R> mapper) {
            return null;
        }

        public <R extends Compiled> PluralFieldBuildProcessor<D, S, R, L> compile(Class<? super R> compiledClass) {
            return null;
        }

        public <R extends Compiled> PluralFieldBuildProcessor<D, S, R, L> compile(CompileConstructor<R, T> constructor, CompileBuilder<R, T> builder) {
            return null;
        }

        @Override
        public void handle(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
            ArrayList<Object> result;
            if (this.arrayGetter == null) {
                return;
            }
            T[] array = this.arrayGetter.apply(source);
            ArrayList<T> list = new ArrayList<T>(array.length);
            for (Object value : array) {
                if (this.operations != null) {
                    for (FieldOperation<D, S, T, T> h : this.operations) {
                        value = h.handle(value, compiled, source, context, p);
                    }
                }
                list.add(value);
            }
            if (this.collector != null) {
                L collection = this.collector.supplier().get();
                for (Object value : list) {
                    this.collector.accumulator().accept(collection, value);
                }
                result = this.collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? collection : this.collector.finisher().apply(collection);
            } else {
                result = list;
            }
            if (this.listSetter != null) {
                this.listSetter.accept(compiled, result);
            }
        }

        private void addOperation(FieldOperation<D, S, T, T> handler) {
            if (this.operations == null) {
                this.operations = new ArrayList<FieldOperation<D, S, T, T>>();
            }
            this.operations.add(handler);
        }
    }

    public static class FieldCompileBuilderImpl<D, S, T>
    implements FieldBuildProcessor<D, S, T>,
    ClassOperation<D, S> {
        private FieldCompileBuilderImpl upstream;
        private Function<S, ? extends T> getter;
        private BiConsumer<D, ? super T> setter;
        private List<FieldOperation<D, S, T, T>> operations;
        private FieldOperation<D, S, T, ?> mapper;

        FieldCompileBuilderImpl(Function<S, ? extends T> getter) {
            this.getter = getter;
        }

        FieldCompileBuilderImpl(FieldCompileBuilderImpl<D, S, ?> previous) {
            previous.upstream = this;
        }

        public void set(BiConsumer<D, ? super T> setter) {
            this.setter = setter;
        }

        public void put(Function<D, ? extends Map<String, Object>> mapGetter, String key) {
            this.setter = (t, v) -> ((Map)mapGetter.apply(t)).put(key, v);
        }

        public <R> FieldBuildProcessor<D, S, R> map(Function<T, R> mapper) {
            this.addMapper((v, d, s, c, p) -> mapper.apply(v));
            return new FieldCompileBuilderImpl<D, S, T>(this);
        }

        public <R extends Compiled> FieldBuildProcessor<D, S, R> compile(Class<? super R> compiledClazz) {
            this.addMapper((v, d, s, c, p) -> p.compile(v, c, new Object[0]));
            return new FieldCompileBuilderImpl<D, S, T>(this);
        }

        public <R extends Compiled> FieldBuildProcessor<D, S, R> compile(CompileConstructor<R, T> constructor, CompileBuilder<R, T> builder) {
            this.addMapper((v, d, s, c, p) -> {
                Compiled result = constructor.construct(v);
                return result;
            });
            return new FieldCompileBuilderImpl<D, S, T>(this);
        }

        public FieldBuildProcessor<D, S, T> defaults(T defaultValue) {
            this.addOperation((v, d, s, c, p) -> v != null ? v : defaultValue);
            return this;
        }

        public FieldBuildProcessor<D, S, T> defaults(Function<S, T> defaultValue) {
            this.addOperation((v, d, s, c, p) -> v != null ? v : defaultValue.apply(s));
            return this;
        }

        public FieldBuildProcessor<D, S, String> resolve() {
            this.addMapper((v, d, s, c, p) -> v instanceof String ? p.resolve((String)v) : v);
            return new FieldCompileBuilderImpl<D, S, T>(this);
        }

        public <R> FieldBuildProcessor<D, S, R> resolve(Class<R> resolvedClazz) {
            this.addMapper((v, d, s, c, p) -> v instanceof String ? p.resolve((String)v, resolvedClazz) : v);
            return new FieldCompileBuilderImpl<D, S, T>(this);
        }

        void build(T value, D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
            if (this.operations != null) {
                for (FieldOperation<D, S, T, T> h : this.operations) {
                    value = h.handle(value, compiled, source, context, p);
                }
            }
            if (this.mapper != null) {
                Object result = this.mapper.handle(value, compiled, source, context, p);
                this.upstream.build(result, compiled, source, context, p);
            }
            if (this.setter != null) {
                this.setter.accept(compiled, value);
            }
        }

        @Override
        public void handle(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
            if (this.getter == null) {
                return;
            }
            this.build(this.getter.apply(source), compiled, source, context, p);
        }

        private void addOperation(FieldOperation<D, S, T, T> handler) {
            if (this.operations == null) {
                this.operations = new ArrayList<FieldOperation<D, S, T, T>>();
            }
            this.operations.add(handler);
        }

        private <R> void addMapper(FieldOperation<D, S, T, R> handler) {
            this.mapper = handler;
        }
    }
}

