/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.plain.N2oCodeViewer;
import net.n2oapp.framework.api.metadata.meta.control.CodeViewer;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import org.springframework.stereotype.Component;

@Component
public class CodeViewerCompiler
extends StandardFieldCompiler<CodeViewer, N2oCodeViewer> {
    public Class<? extends Source> getSourceClass() {
        return N2oCodeViewer.class;
    }

    public StandardField<CodeViewer> compile(N2oCodeViewer source, CompileContext<?, ?> context, CompileProcessor p) {
        CodeViewer codeViewer = new CodeViewer();
        codeViewer.setText(source.getText().trim().replaceAll("\n( )+", "\n"));
        codeViewer.setLanguage(source.getLanguage());
        codeViewer.setDarkTheme(Boolean.valueOf(source.getTheme() != null && source.getTheme().equals((Object)N2oCodeViewer.ColorTheme.dark)));
        codeViewer.setShowLineNumbers((Boolean)p.cast((Object)source.getShowLineNumbers(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.code.show-line-numbers"), Boolean.class)), new Object[0]));
        codeViewer.setStartingLineNumber((Integer)p.cast((Object)source.getStartingLineNumber(), (Object)1, new Object[0]));
        codeViewer.setHideButtons((Boolean)p.cast((Object)source.getHideButtons(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.code.hide-buttons"), Boolean.class)), new Object[0]));
        codeViewer.setHideOverflow((Boolean)p.cast((Object)source.getHideOverflow(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.code.hide-overflow"), Boolean.class)), new Object[0]));
        return this.compileStandardField(codeViewer, source, context, p);
    }

    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.code_viewer.src";
    }
}

