/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.HashMap;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.interval.N2oDateInterval;
import net.n2oapp.framework.api.metadata.domain.Domain;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;
import net.n2oapp.framework.api.metadata.meta.control.DateInterval;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import org.springframework.stereotype.Component;

@Component
public class DateIntervalCompiler
extends StandardFieldCompiler<DateInterval, N2oDateInterval> {
    public Class<? extends Source> getSourceClass() {
        return N2oDateInterval.class;
    }

    public StandardField<DateInterval> compile(N2oDateInterval source, CompileContext<?, ?> context, CompileProcessor p) {
        DateInterval dateInterval = new DateInterval();
        source.setDomain((String)p.cast((Object)source.getDomain(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.control.date_interval.domain"), String.class)), new Object[0]));
        Domain domain = Domain.getByName((String)source.getDomain());
        if (domain == null || domain.getJsFormat() == null) {
            throw new IllegalStateException("Wrong domain for control " + source.getId());
        }
        dateInterval.setOutputFormat(domain.getJsFormat());
        dateInterval.setDateFormat((String)p.cast((Object)source.getDateFormat(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.control.date_interval.format"), String.class)), new Object[0]));
        dateInterval.setTimeFormat(source.getTimeFormat());
        dateInterval.setMin(p.resolveJS(source.getMin()));
        dateInterval.setMax(p.resolveJS(source.getMax()));
        dateInterval.setUtc((Boolean)p.cast((Object)source.getUtc(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.date_interval.utc"), Boolean.class)), new Object[0]));
        return this.compileStandardField(dateInterval, source, context, p);
    }

    @Override
    protected Object compileDefValues(N2oDateInterval source, CompileProcessor p) {
        if (source.getBegin() == null && source.getEnd() == null) {
            return null;
        }
        DefaultValues values = new DefaultValues();
        values.setValues(new HashMap());
        if (source.getBegin() != null) {
            values.getValues().put("begin", source.getBegin());
        }
        if (source.getEnd() != null) {
            values.getValues().put("end", source.getEnd());
        }
        return values;
    }

    @Override
    protected void compileParams(StandardField<DateInterval> control, N2oDateInterval source, WidgetParamScope paramScope, CompileProcessor p) {
        ModelsScope modelsScope;
        if ((source.getBeginParam() != null || source.getEndParam() != null) && (modelsScope = (ModelsScope)p.getScope(ModelsScope.class)) != null) {
            ReduxAction onGet;
            ModelLink onSet;
            String fieldId;
            if (source.getBeginParam() != null) {
                fieldId = control.getId() + ".begin";
                onSet = new ModelLink(modelsScope.getModel(), modelsScope.getWidgetId(), fieldId);
                onSet.setParam(source.getBeginParam());
                onGet = Redux.dispatchUpdateModel(modelsScope.getWidgetId(), modelsScope.getModel(), fieldId, Placeholders.colon((String)source.getBeginParam()));
                paramScope.addQueryMapping(source.getBeginParam(), onGet, (BindLink)onSet);
            }
            if (source.getEndParam() != null) {
                fieldId = control.getId() + ".end";
                onSet = new ModelLink(modelsScope.getModel(), modelsScope.getWidgetId(), fieldId);
                onSet.setParam(source.getEndParam());
                onGet = Redux.dispatchUpdateModel(modelsScope.getWidgetId(), modelsScope.getModel(), fieldId, Placeholders.colon((String)source.getEndParam()));
                paramScope.addQueryMapping(source.getEndParam(), onGet, (BindLink)onSet);
            }
        }
    }

    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.date_interval.src";
    }
}

