/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.dataprovider;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ModelAware;
import net.n2oapp.framework.api.metadata.aware.WidgetIdAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.context.ActionContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.CompileUtil;

public class ClientDataProviderUtil {
    private ClientDataProviderUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static ClientDataProvider compile(N2oClientDataProvider compiled, CompileContext<?, ?> context, CompileProcessor p) {
        ClientDataProvider dataProvider = new ClientDataProvider();
        String path = null;
        String targetWidget = compiled.getTargetWidgetId() == null ? ClientDataProviderUtil.initTargetWidget(context, p) : compiled.getTargetWidgetId();
        ReduxModel targetModel = ClientDataProviderUtil.initTargetWidgetModel(p, compiled.getTargetModel());
        if (RequestMethod.POST == compiled.getMethod() || RequestMethod.PUT == compiled.getMethod() || RequestMethod.DELETE == compiled.getMethod()) {
            StrictMap pathMapping = new StrictMap();
            pathMapping.putAll(ClientDataProviderUtil.compileParams(compiled.getPathParams(), context, p, targetModel, targetWidget));
            dataProvider.setFormMapping(ClientDataProviderUtil.compileParams((N2oParam[])compiled.getFormParams(), context, p, targetModel, targetWidget));
            dataProvider.setHeadersMapping(ClientDataProviderUtil.compileParams(compiled.getHeaderParams(), context, p, targetModel, targetWidget));
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            path = (String)p.cast((Object)(routeScope != null ? routeScope.getUrl() : null), (Object)context.getRoute((BindProcessor)((N2oCompileProcessor)p)), new Object[]{""});
            if (context.getPathRouteMapping() != null) {
                pathMapping.putAll(context.getPathRouteMapping());
            }
            path = RouteUtil.normalize(path + RouteUtil.normalize((String)p.cast((Object)compiled.getUrl(), (Object)compiled.getId(), new Object[]{""})));
            dataProvider.setPathMapping((Map)pathMapping);
            dataProvider.setMethod(compiled.getMethod());
            dataProvider.setOptimistic(compiled.getOptimistic());
            dataProvider.setSubmitForm(compiled.getSubmitForm());
            ClientDataProviderUtil.initActionContext(compiled, (Map<String, ModelLink>)pathMapping, (String)p.cast((Object)path, (Object)compiled.getUrl(), new Object[0]), p);
        }
        dataProvider.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + (String)p.cast(path, (Object)compiled.getUrl(), new Object[0]));
        dataProvider.setQueryMapping(ClientDataProviderUtil.compileParams(compiled.getQueryParams(), context, p, targetModel, targetWidget));
        dataProvider.setQuickSearchParam(compiled.getQuickSearchParam());
        dataProvider.setSize(compiled.getSize());
        return dataProvider;
    }

    public static String getWidgetIdByComponentScope(CompileProcessor p) {
        String widgetId = null;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null) {
            PageScope pageScope = (PageScope)p.getScope(PageScope.class);
            WidgetIdAware widgetIdAware = componentScope.unwrap(WidgetIdAware.class);
            if (widgetIdAware != null && widgetIdAware.getWidgetId() != null) {
                widgetId = pageScope == null ? widgetIdAware.getWidgetId() : pageScope.getGlobalWidgetId(widgetIdAware.getWidgetId());
            }
        }
        return widgetId;
    }

    private static Map<String, ModelLink> compileParams(N2oParam[] params, CompileContext<?, ?> context, CompileProcessor p, ReduxModel model, String targetWidgetId) {
        if (params == null) {
            return Collections.emptyMap();
        }
        StrictMap result = new StrictMap();
        for (N2oParam param : params) {
            ModelLink link = param.getValueParam() == null ? ClientDataProviderUtil.getModelLink(p, model, targetWidgetId, param) : ClientDataProviderUtil.getModelLinkByParam(context, param);
            if (link == null) continue;
            result.put(param.getName(), link);
        }
        return result;
    }

    private static ModelLink getModelLink(CompileProcessor p, ReduxModel model, String targetWidgetId, N2oParam param) {
        ModelLink link;
        Object value;
        Object object = value = param.getValueList() != null ? param.getValueList() : ScriptProcessor.resolveExpression((String)param.getValue());
        if (value == null || StringUtils.isJs((Object)value)) {
            String widgetId = null;
            if (param.getRefWidgetId() != null) {
                PageScope pageScope;
                String pageId = param.getRefPageId();
                if (param.getRefPageId() == null && (pageScope = (PageScope)p.getScope(PageScope.class)) != null) {
                    pageId = pageScope.getPageId();
                }
                widgetId = CompileUtil.generateWidgetId(pageId, param.getRefWidgetId());
            }
            link = new ModelLink((ReduxModel)p.cast((Object)param.getRefModel(), (Object)model, new Object[0]), (String)p.cast((Object)widgetId, (Object)targetWidgetId, new Object[0]));
            link.setValue(value);
        } else {
            link = new ModelLink(value);
        }
        return link;
    }

    private static ModelLink getModelLinkByParam(CompileContext<?, ?> context, N2oParam param) {
        ModelLink link = null;
        if (context.getPathRouteMapping() != null && context.getPathRouteMapping().containsKey(param.getValueParam())) {
            link = (ModelLink)context.getPathRouteMapping().get(param.getValueParam());
            link.setParam(param.getValueParam());
        } else if (context.getQueryRouteMapping() != null && context.getQueryRouteMapping().containsKey(param.getValueParam())) {
            link = (ModelLink)context.getQueryRouteMapping().get(param.getValueParam());
            link.setParam(param.getValueParam());
        } else {
            link = new ModelLink();
            link.setParam(param.getValueParam());
        }
        return link;
    }

    private static void initActionContext(N2oClientDataProvider source, Map<String, ModelLink> pathMapping, String url, CompileProcessor p) {
        if (source.getActionContextData() != null) {
            N2oClientDataProvider.ActionContextData actionContextData = source.getActionContextData();
            ActionContext actionContext = new ActionContext(actionContextData.getObjectId(), actionContextData.getOperationId(), url);
            StrictMap routePathMapping = new StrictMap();
            StrictMap routeQueryMapping = new StrictMap();
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            if (routeScope != null) {
                routePathMapping.putAll(routeScope.getPathMapping());
                routePathMapping.putAll(pathMapping);
                routeQueryMapping.putAll(routeScope.getQueryMapping());
            }
            actionContext.setPathRouteMapping((Map<String, ModelLink>)routePathMapping);
            actionContext.setQueryRouteMapping((Map<String, ModelLink>)routeQueryMapping);
            ValidationList validationList = (ValidationList)p.getScope(ValidationList.class);
            actionContext.setValidations(validationList == null ? null : validationList.get(actionContextData.getFailAlertWidgetId(), ClientDataProviderUtil.initTargetWidgetModel(p, source.getTargetModel())));
            actionContext.setRedirect(actionContextData.getRedirect());
            actionContext.setRefresh(actionContextData.getRefresh());
            PageScope pageScope = (PageScope)p.getScope(PageScope.class);
            if (pageScope != null) {
                actionContext.setParentPageId(pageScope.getPageId());
            }
            actionContext.setParentWidgetId(actionContextData.getParentWidgetId());
            actionContext.setFailAlertWidgetId(actionContextData.getFailAlertWidgetId());
            actionContext.setMessagesForm(actionContextData.getMessagesForm());
            actionContext.setSuccessAlertWidgetId(actionContextData.getSuccessAlertWidgetId());
            actionContext.setMessageOnSuccess(actionContextData.isMessageOnSuccess());
            actionContext.setMessageOnFail(actionContextData.isMessageOnFail());
            HashSet formParams = new HashSet();
            if (source.getFormParams() != null) {
                Arrays.stream(source.getFormParams()).forEach(fp -> formParams.add(fp.getId()));
            }
            StrictMap operationMapping = new StrictMap();
            for (AbstractParameter inParameter : actionContextData.getOperation().getInParametersMap().values()) {
                String param;
                if (!(inParameter instanceof ObjectSimpleField) || (param = ((ObjectSimpleField)inParameter).getParam()) == null || formParams.contains(param)) continue;
                operationMapping.put(param, inParameter.getId());
            }
            actionContext.setOperationMapping((Map<String, String>)operationMapping);
            p.addRoute((CompileContext)actionContext);
        }
    }

    private static String initTargetWidget(CompileContext<?, ?> context, CompileProcessor p) {
        WidgetIdAware widgetIdAware;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        String targetWidgetId = null;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (widgetIdAware = componentScope.unwrap(WidgetIdAware.class)) != null && widgetIdAware.getWidgetId() != null) {
            String string = targetWidgetId = pageScope == null ? widgetIdAware.getWidgetId() : pageScope.getGlobalWidgetId(widgetIdAware.getWidgetId());
        }
        if (targetWidgetId == null) {
            if (widgetScope != null) {
                targetWidgetId = widgetScope.getClientWidgetId();
            } else if (context instanceof PageContext && ((PageContext)context).getResultWidgetId() != null && pageScope != null) {
                targetWidgetId = pageScope.getGlobalWidgetId(((PageContext)context).getResultWidgetId());
            } else {
                throw new N2oException("Unknown widgetId for invoke action!");
            }
        }
        return targetWidgetId;
    }

    private static ReduxModel initTargetWidgetModel(CompileProcessor p, ReduxModel defaultModel) {
        ModelAware modelAware;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (modelAware = componentScope.unwrap(ModelAware.class)) != null && modelAware.getModel() != null) {
            return modelAware.getModel();
        }
        return defaultModel;
    }
}

