/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.header;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.header.N2oSearchBar;
import net.n2oapp.framework.api.metadata.header.SearchBar;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.context.HeaderContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.util.QueryContextUtil;
import org.springframework.stereotype.Component;

@Component
public class SearchBarCompiler
implements BaseSourceCompiler<SearchBar, N2oSearchBar, HeaderContext>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oSearchBar.class;
    }

    public SearchBar compile(N2oSearchBar source, HeaderContext context, CompileProcessor p) {
        SearchBar searchBar = new SearchBar();
        searchBar.setUrlFieldId(source.getUrlFieldId());
        searchBar.setLabelFieldId(source.getLabelFieldId());
        searchBar.setIconFieldId(source.getIconFieldId());
        searchBar.setDescrFieldId(source.getDescriptionFieldId());
        searchBar.setSearchPageLocation(this.initPageLocation(source));
        searchBar.setDataProvider(this.initDataProvider(source, p));
        return searchBar;
    }

    private SearchBar.SearchPageLocation initPageLocation(N2oSearchBar source) {
        SearchBar.SearchPageLocation pageLocation = new SearchBar.SearchPageLocation();
        pageLocation.setUrl(source.getAdvancedUrl());
        pageLocation.setSearchQueryName(source.getAdvancedParam());
        pageLocation.setLinkType(source.getAdvancedTarget() == Target.newWindow ? SearchBar.LinkType.outer : SearchBar.LinkType.inner);
        return pageLocation;
    }

    private ClientDataProvider initDataProvider(N2oSearchBar source, CompileProcessor p) {
        ClientDataProvider dataProvider = new ClientDataProvider();
        QueryContext queryContext = new QueryContext(source.getQueryId());
        ModelsScope modelsScope = (ModelsScope)p.getScope(ModelsScope.class);
        queryContext.setFailAlertWidgetId(modelsScope != null ? modelsScope.getWidgetId() : null);
        CompiledQuery query = (CompiledQuery)p.getCompiled((CompileContext)queryContext);
        p.addRoute((CompileContext)QueryContextUtil.prepareQueryContextForRouteRegister(query));
        dataProvider.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + query.getRoute());
        dataProvider.setQuickSearchParam(source.getFilterFieldId());
        return dataProvider;
    }
}

