/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.region;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.BasePageUtil;
import net.n2oapp.framework.api.metadata.global.view.region.N2oTabsRegion;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.region.TabsRegion;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.region.BaseRegionCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.PageWidgetsScope;
import org.springframework.stereotype.Component;

@Component
public class TabsRegionCompiler
extends BaseRegionCompiler<TabsRegion, N2oTabsRegion> {
    @Override
    protected String getSrcProperty() {
        return "n2o.api.region.tabs.src";
    }

    public Class<N2oTabsRegion> getSourceClass() {
        return N2oTabsRegion.class;
    }

    public TabsRegion compile(N2oTabsRegion source, PageContext context, CompileProcessor p) {
        TabsRegion region = new TabsRegion();
        this.build(region, source, p);
        IndexScope indexScope = (IndexScope)p.getScope(IndexScope.class);
        PageWidgetsScope pageWidgetsScope = (PageWidgetsScope)p.getScope(PageWidgetsScope.class);
        region.setItems(this.initItems(source, indexScope, pageWidgetsScope, context, p));
        region.setAlwaysRefresh(Boolean.valueOf(source.getAlwaysRefresh() != null ? source.getAlwaysRefresh() : false));
        region.setLazy((Boolean)p.cast((Object)source.getLazy(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.region.tabs.lazy"), Boolean.class)), new Object[0]));
        region.setScrollbar((Boolean)p.cast((Object)source.getScrollbar(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.region.tabs.scrollbar"), Boolean.class)), new Object[0]));
        region.setMaxHeight((String)p.cast((Object)source.getMaxHeight(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.region.tabs.max_height"), String.class)), new Object[0]));
        region.setHideSingleTab((Boolean)p.cast((Object)source.getHideSingleTab(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.region.tabs.hide_single_tab"), Boolean.class)), new Object[0]));
        this.compileTabsRoute(source, region.getId(), p);
        return region;
    }

    private void compileTabsRoute(N2oTabsRegion source, String regionId, CompileProcessor p) {
        String activeParam = (String)p.cast((Object)source.getActiveParam(), (Object)regionId, new Object[0]);
        Boolean routable = (Boolean)p.cast((Object)source.getRoutable(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.region.tabs.routable"), Boolean.class)), new Object[0]);
        PageRoutes routes = (PageRoutes)p.getScope(PageRoutes.class);
        if (routes == null || !Boolean.TRUE.equals(routable)) {
            return;
        }
        routes.addQueryMapping(activeParam, Redux.dispatchSetActiveRegionEntity(regionId, activeParam), Redux.createActiveRegionEntityLink(regionId));
    }

    @Override
    protected String createId(String regionPlace, CompileProcessor p) {
        return this.createId(regionPlace, "tabs", p);
    }

    protected List<TabsRegion.Tab> initItems(N2oTabsRegion source, IndexScope index, PageWidgetsScope pageWidgetsScope, PageContext context, CompileProcessor p) {
        ArrayList<TabsRegion.Tab> items = new ArrayList<TabsRegion.Tab>();
        if (source.getTabs() != null) {
            for (N2oTabsRegion.Tab t : source.getTabs()) {
                TabsRegion.Tab tab = new TabsRegion.Tab();
                tab.setId((String)p.cast((Object)t.getId(), (Object)this.createId(null, source.getAlias(), p), new Object[0]));
                tab.setLabel(t.getName());
                tab.setProperties(p.mapAttributes((ExtensionAttributesAware)t));
                ArrayList content = new ArrayList();
                if (t.getContent() != null) {
                    BasePageUtil.resolveRegionItems((SourceComponent[])t.getContent(), item -> content.add(p.compile(item, (CompileContext)context, new Object[]{p, index})), item -> pageWidgetsScope.getWidgets().keySet().stream().filter(k -> k.endsWith(item.getId())).findFirst().ifPresent(s -> content.add((Compiled)pageWidgetsScope.getWidgets().get(s))));
                }
                tab.setContent(content);
                tab.setOpened(Boolean.valueOf(items.isEmpty()));
                items.add(tab);
            }
        }
        return items;
    }
}

