/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.persister.control;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.CssClassAware;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.control.N2oStandardField;
import net.n2oapp.framework.api.metadata.control.interval.N2oSimpleIntervalField;
import net.n2oapp.framework.api.metadata.control.list.N2oSelectTree;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.view.widget.tree.InheritanceNodes;
import net.n2oapp.framework.api.metadata.persister.AbstractN2oMetadataPersister;
import net.n2oapp.framework.config.persister.tools.PreFilterPersister;
import net.n2oapp.framework.config.persister.util.CssClassAwarePersister;
import net.n2oapp.framework.config.persister.util.PersisterJdomUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class N2oControlXmlPersister<T extends N2oField>
extends AbstractN2oMetadataPersister<T> {
    private ObjectMapper mapper = new ObjectMapper();

    public N2oControlXmlPersister() {
        super("http://n2oapp.net/framework/config/schema/n2o-control-1.0", "ctrl");
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    protected void setControl(Element element, N2oField n2oControl) {
        if (n2oControl.getLabel() != null) {
            element.setAttribute("label", n2oControl.getLabel());
        }
        PersisterJdomUtil.setAttribute(element, "visible", n2oControl.getVisible());
        PersisterJdomUtil.setElementString(element, "description", n2oControl.getDescription());
        element.setAttribute("id", n2oControl.getId());
        if (n2oControl instanceof N2oStandardField) {
            PersisterJdomUtil.setElementString(element, "placeholder", ((N2oStandardField)n2oControl).getPlaceholder());
        }
    }

    protected void setListField(Element element, N2oListField n2oField) {
        if (n2oField.getCache() != null) {
            if (n2oField.getCache().booleanValue()) {
                PersisterJdomUtil.setAttribute(element, "cache", "on");
            } else if (!n2oField.getCache().booleanValue()) {
                PersisterJdomUtil.setAttribute(element, "cache", "off");
            }
        }
        PersisterJdomUtil.setAttribute(element, "autoselect-alone", n2oField.getAutoselectAlone());
        PersisterJdomUtil.setAttribute(element, "autoselect-first", n2oField.getAutoselectFirst());
        PersisterJdomUtil.setAttribute(element, "popup-scaling", (Enum)n2oField.getPopupScaling());
        PersisterJdomUtil.setAttribute(element, "size", n2oField.getSize());
        this.setDefaultModel(element, (N2oField)n2oField);
    }

    protected void setTreeField(Element element, N2oSelectTree selectTree) {
        PersisterJdomUtil.setAttribute(element, "ajax", selectTree.getAjax());
        PersisterJdomUtil.setAttribute(element, "search", selectTree.getSearch());
        PersisterJdomUtil.setAttribute(element, "checkboxes", selectTree.getCheckboxes());
        InheritanceNodes in = selectTree.getInheritanceNodes();
        if (in != null) {
            Element inheritanceNodes = new Element("inheritance-nodes", this.namespacePrefix, this.namespaceUri);
            PersisterJdomUtil.setAttribute(inheritanceNodes, "parent-field-id", in.getParentFieldId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "label-field-id", in.getLabelFieldId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "value-field-id", in.getValueFieldId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "detail-field-id", in.getDetailFieldId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "master-field-id", in.getMasterFieldId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "query-id", in.getQueryId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "has-children-field-id", in.getHasChildrenFieldId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "icon-field-id", in.getIconFieldId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "search-field-id", in.getSearchFilterId());
            PersisterJdomUtil.setAttribute(inheritanceNodes, "enabled-field-id", in.getEnabledFieldId());
            PreFilterPersister.setPreFilter(in.getPreFilters(), inheritanceNodes, Namespace.getNamespace((String)this.namespacePrefix, (String)this.namespaceUri));
            element.addContent((Content)inheritanceNodes);
        }
    }

    protected void setField(Element element, N2oField n2oField) {
        if (n2oField.getDependsOn() != null) {
            PersisterJdomUtil.setAttribute(element, "depends-on", n2oField.getDependsOn()[0]);
        }
        PersisterJdomUtil.setAttribute(element, "dependency-condition", this.persistDependencyCondition(n2oField));
        PersisterJdomUtil.setAttribute(element, "domain", n2oField.getDomain());
        PersisterJdomUtil.setAttribute(element, "required", n2oField.getRequired());
        PersisterJdomUtil.setAttribute(element, "label-style", n2oField.getLabelStyle());
        if (n2oField instanceof N2oStandardField) {
            PersisterJdomUtil.setAttribute(element, "copied", ((N2oStandardField)n2oField).getCopied());
            this.setValidations((N2oStandardField)n2oField, element);
            if (((N2oStandardField)n2oField).getDefaultValue() != null) {
                PersisterJdomUtil.setAttribute(element, "default-value", ((N2oStandardField)n2oField).getDefaultValue());
            }
        }
        PersisterJdomUtil.setAttribute(element, "control-style", n2oField.getStyle());
        PersisterJdomUtil.setAttribute(element, "src", n2oField.getSrc());
        CssClassAwarePersister.getInstance().persist(element, (CssClassAware)n2oField);
        this.setDependencies(n2oField, element);
    }

    protected void setListQuery(Element element, N2oListField control) {
        if (control.getQueryId() == null) {
            return;
        }
        Element queryEl = new Element("query", this.namespacePrefix, this.namespaceUri);
        element.addContent((Content)queryEl);
        PersisterJdomUtil.setAttribute(queryEl, "query-id", control.getQueryId());
        PersisterJdomUtil.setAttribute(queryEl, "master-field-id", control.getMasterFieldId());
        PersisterJdomUtil.setAttribute(queryEl, "detail-field-id", control.getDetailFieldId());
        PersisterJdomUtil.setAttribute(queryEl, "label-field-id", control.getLabelFieldId());
        PersisterJdomUtil.setAttribute(queryEl, "search-field-id", control.getSearchFilterId());
        PersisterJdomUtil.setAttribute(queryEl, "value-field-id", control.getValueFieldId());
        PersisterJdomUtil.setAttribute(queryEl, "format", control.getFormat());
        PersisterJdomUtil.setAttribute(queryEl, "icon-field-id", control.getIconFieldId());
        PreFilterPersister.setPreFilter(control.getPreFilters(), queryEl, queryEl.getNamespace());
    }

    protected void setDefaultModel(Element element, N2oField listField) {
        if (listField instanceof N2oListField) {
            if (((N2oListField)listField).getDefValue() == null) {
                return;
            }
            Element defaultModel = PersisterJdomUtil.setEmptyElement(element, "default-model");
            ((N2oListField)listField).getDefValue().forEach((field, val) -> {
                Element value = PersisterJdomUtil.setEmptyElement(defaultModel, "value");
                PersisterJdomUtil.setAttribute(value, "field-id", field);
                value.setText(val);
            });
        } else if (listField instanceof N2oSimpleIntervalField) {
            if (((N2oSimpleIntervalField)listField).getBegin() == null && ((N2oSimpleIntervalField)listField).getEnd() == null) {
                return;
            }
            Element defaultModel = PersisterJdomUtil.setEmptyElement(element, "default-model");
            PersisterJdomUtil.setAttribute(defaultModel, "begin", ((N2oSimpleIntervalField)listField).getBegin());
            PersisterJdomUtil.setAttribute(defaultModel, "end", ((N2oSimpleIntervalField)listField).getEnd());
        }
    }

    protected void setOptionsList(Element element, Map<String, String>[] options) {
        if (options == null) {
            return;
        }
        Element optElement = new Element("options", this.namespacePrefix, this.namespaceUri);
        element.addContent((Content)optElement);
        for (Map<String, String> option : options) {
            String json;
            Element itemElement = new Element("option", this.namespacePrefix, this.namespaceUri);
            try {
                json = this.mapper.writer().writeValueAsString(option);
            }
            catch (JsonProcessingException e) {
                throw new N2oException((Throwable)e);
            }
            itemElement.setText(json);
            optElement.addContent((Content)itemElement);
        }
    }

    protected Element getPreFilter(List<N2oPreFilter> preFilters) {
        if (preFilters != null && preFilters.size() > 0) {
            Element preFiltersElement = new Element("pre-filters", this.namespacePrefix, this.namespaceUri);
            for (N2oPreFilter n2oPreFilter : preFilters) {
                Element preFilterElement = new Element("pre-filter", this.namespacePrefix, this.namespaceUri);
                preFiltersElement.addContent((Content)preFilterElement);
                if (n2oPreFilter.getFieldId() != null) {
                    preFilterElement.setAttribute("field-id", n2oPreFilter.getFieldId());
                }
                if (n2oPreFilter.getRef() != null) {
                    preFilterElement.setAttribute("ref", n2oPreFilter.getRef());
                }
                if (n2oPreFilter.getValue() != null) {
                    preFilterElement.setAttribute("value", n2oPreFilter.getValue());
                }
                if (n2oPreFilter.getType() != null) {
                    preFilterElement.setAttribute("type", n2oPreFilter.getType().name());
                }
                if (n2oPreFilter.getValues() == null) continue;
                for (String value : n2oPreFilter.getValues()) {
                    PersisterJdomUtil.setElementString(preFilterElement, "value", value);
                }
            }
            return preFiltersElement;
        }
        return null;
    }

    private String persistDependencyCondition(N2oField n2oField) {
        if (n2oField.getDependencies() == null) {
            return null;
        }
        for (N2oField.Dependency dependency : n2oField.getDependencies()) {
            if (!(dependency instanceof N2oField.VisibilityDependency)) continue;
            return dependency.getValue();
        }
        return null;
    }

    private void setValidations(N2oStandardField field, Element rootElement) {
        if (field.getValidations() == null || field.getValidations().getWhiteList() == null) {
            return;
        }
        Element validations = PersisterJdomUtil.setEmptyElement(rootElement, "validations");
        for (String reference : field.getValidations().getWhiteList()) {
            Element validation = PersisterJdomUtil.setEmptyElement(validations, "validation");
            PersisterJdomUtil.setAttribute(validation, "ref-id", reference);
        }
    }

    private void setDependencies(N2oField field, Element rootElement) {
        if (field.getDependencies() != null) {
            Element dependencies = null;
            for (N2oField.Dependency dependency : field.getDependencies()) {
                String on;
                if (dependency instanceof N2oField.EnablingDependency) {
                    if (dependencies == null) {
                        dependencies = PersisterJdomUtil.setEmptyElement(rootElement, "dependencies");
                    }
                    Element enable = PersisterJdomUtil.setElementString(dependencies, "enabling-condition", dependency.getValue());
                    if (dependency.getOn() == null) continue;
                    on = String.join((CharSequence)",", dependency.getOn());
                    PersisterJdomUtil.setAttribute(enable, "on", on);
                    continue;
                }
                if (dependency instanceof N2oField.RequiringDependency) {
                    if (dependencies == null) {
                        dependencies = PersisterJdomUtil.setEmptyElement(rootElement, "dependencies");
                    }
                    Element required = PersisterJdomUtil.setElementString(dependencies, "required-condition", dependency.getValue());
                    if (dependency.getOn() == null) continue;
                    on = String.join((CharSequence)",", dependency.getOn());
                    PersisterJdomUtil.setAttribute(required, "on", on);
                    continue;
                }
                if (!(dependency instanceof N2oField.SetValueDependency)) continue;
                Element setValueExp = PersisterJdomUtil.setElementString(rootElement, "set-value-expression", dependency.getValue());
                if (dependency.getOn() == null) continue;
                on = String.join((CharSequence)",", dependency.getOn());
                PersisterJdomUtil.setAttribute(setValueExp, "on", on);
            }
        }
    }
}

