/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.n2oapp.engine.factory.EngineNotFoundException;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.aware.ReaderFactoryAware;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.io.ProxyNamespaceIO;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import org.jdom2.Namespace;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class N2oNamespaceReaderFactory<T extends NamespaceUriAware>
implements NamespaceReaderFactory<T, NamespaceReader<T>>,
ApplicationContextAware,
IOProcessorAware {
    private ApplicationContext applicationContext;
    private IOProcessor processor;
    private volatile Map<String, Map<String, NamespaceReader<T>>> engines;

    public NamespaceReader<T> produce(String elementName, Namespace ... namespaces) {
        if (this.engines == null) {
            this.initFactory();
        }
        HashMap<String, NamespaceReader<T>> elementReaders = new HashMap<String, NamespaceReader<T>>();
        for (Namespace namespace : namespaces) {
            if (!this.engines.containsKey(namespace.getURI())) continue;
            elementReaders.putAll(this.engines.get(namespace.getURI()));
        }
        if (elementReaders.isEmpty()) {
            throw new EngineNotFoundException((Object)elementName);
        }
        NamespaceReader reader = (NamespaceReader)elementReaders.get(elementName);
        if (reader == null) {
            throw new EngineNotFoundException((Object)elementName);
        }
        if (reader instanceof ReaderFactoryAware) {
            ((ReaderFactoryAware)reader).setReaderFactory((NamespaceReaderFactory)this);
        }
        if (reader instanceof IOProcessorAware) {
            ((IOProcessorAware)reader).setIOProcessor(this.processor);
        }
        return reader;
    }

    private synchronized void initFactory() {
        if (this.engines == null) {
            HashMap result = new HashMap();
            ArrayList beans = new ArrayList(this.applicationContext.getBeansOfType(NamespaceReader.class).values());
            if (this.processor != null) {
                for (NamespaceIO ioBean : this.applicationContext.getBeansOfType(NamespaceIO.class).values()) {
                    beans.add(new ProxyNamespaceIO(ioBean, this.processor));
                }
            }
            beans.forEach(b -> {
                String namespaceUri = b.getNamespaceUri();
                if (result.containsKey(namespaceUri)) {
                    ((Map)result.get(namespaceUri)).put(b.getElementName(), b);
                } else {
                    HashMap<String, NamespaceReader> typedEngines = new HashMap<String, NamespaceReader>();
                    typedEngines.put(b.getElementName(), (NamespaceReader)b);
                    result.put(namespaceUri, typedEngines);
                }
            });
            this.engines = result;
        }
    }

    public void add(NamespaceReader<T> reader) {
        throw new UnsupportedOperationException();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setIOProcessor(IOProcessor processor) {
        this.processor = processor;
    }
}

