/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.page;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.global.view.action.control.RefreshPolity;
import net.n2oapp.framework.api.metadata.global.view.page.N2oStandardPage;
import net.n2oapp.framework.api.metadata.global.view.region.N2oLineRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oNoneRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oPanelRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oPillsRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oSelectRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oTabsRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.reader.AbstractFactoredReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.reader.tools.CounterReaderV1;
import net.n2oapp.framework.config.reader.tools.PreFilterReaderV1Util;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.springframework.stereotype.Component;

@Component
public class PageXmlReaderV1
extends AbstractFactoredReader<N2oStandardPage> {
    public N2oStandardPage read(Element root, Namespace namespace) {
        Element regionsElem;
        String elementName = root.getName();
        if (!elementName.equals("page")) {
            throw new MetadataReaderException("element <page> not found");
        }
        N2oStandardPage n2oPage = new N2oStandardPage();
        n2oPage.setObjectId(ReaderJdomUtil.getElementString(root, "object-id"));
        n2oPage.setName(ReaderJdomUtil.getElementString(root, "name"));
        n2oPage.setSrc(ReaderJdomUtil.getElementString(root, "src"));
        ArrayList<N2oRegion> regions = new ArrayList<N2oRegion>();
        Element containers = root.getChild("containers", namespace);
        if (containers != null) {
            this.readContainers(n2oPage, regions, containers);
        }
        if ((regionsElem = root.getChild("regions", namespace)) != null) {
            this.readRegions(n2oPage, regions, regionsElem);
        }
        n2oPage.setItems((SourceComponent[])regions.toArray(new N2oRegion[regions.size()]));
        return n2oPage;
    }

    private void readRegions(N2oStandardPage n2oPage, List<N2oRegion> regions, Element regionsElem) {
        List regionElements = regionsElem.getChildren();
        for (Object r : regionElements) {
            Element element = (Element)r;
            List widgetElements = element.getChildren();
            N2oRegion region = this.createRegion(regionElements, ReaderJdomUtil.getAttributeString(element, "type"), widgetElements);
            String src = ReaderJdomUtil.getAttributeString(element, "src");
            if (src != null) {
                region.setSrc(src);
            }
            region.setPlace(ReaderJdomUtil.getAttributeString(element, "place"));
            ArrayList<N2oWidget> widgets = new ArrayList<N2oWidget>();
            for (Object c : widgetElements) {
                N2oWidget wgt = this.readWidget((Element)c, this.readerFactory);
                widgets.add(wgt);
            }
            region.setContent((SourceComponent[])widgets.toArray(new N2oWidget[widgets.size()]));
            regions.add(region);
        }
    }

    private N2oRegion createRegion(List regionElements, String type, List widgetElements) {
        Object region;
        if (type == null) {
            region = widgetElements.size() == 1 && regionElements.size() == 1 ? new N2oNoneRegion() : new N2oTabsRegion();
        } else {
            switch (type) {
                case "tabs": {
                    region = new N2oTabsRegion();
                    break;
                }
                case "panel": {
                    region = new N2oPanelRegion();
                    break;
                }
                case "pills": {
                    region = new N2oPillsRegion();
                    break;
                }
                case "line": 
                case "list": {
                    region = new N2oLineRegion();
                    break;
                }
                case "select": {
                    region = new N2oSelectRegion();
                    break;
                }
                default: {
                    region = new N2oNoneRegion();
                }
            }
        }
        return region;
    }

    private void readContainers(N2oStandardPage n2oPage, List<N2oRegion> regions, Element containers) {
        List containerElements = containers.getChildren();
        for (Object c : containerElements) {
            N2oNoneRegion region;
            Element container = (Element)c;
            if (containerElements.size() == 1) {
                region = new N2oNoneRegion();
                N2oWidget widget = this.readWidget(container, this.readerFactory);
                region.setContent((SourceComponent[])new N2oWidget[]{widget});
            } else {
                region = new N2oTabsRegion();
            }
            region.setPlace(ReaderJdomUtil.getAttributeString(container, "place"));
            regions.add((N2oRegion)region);
        }
    }

    private N2oWidget readWidget(Element element, NamespaceReaderFactory readerFactory) {
        N2oWidget n2oWidget = null;
        for (Object o : element.getChildren()) {
            Element widget = (Element)o;
            if (widget.getNamespace().equals((Object)element.getNamespace())) continue;
            n2oWidget = (N2oWidget)readerFactory.produce(widget).read(widget);
            n2oWidget.setDependsOn(ReaderJdomUtil.getAttributeString(element, "depends-on"));
            n2oWidget.setDependencyCondition(ReaderJdomUtil.getAttributeString(element, "dependency-condition"));
            n2oWidget.setRefreshPolity(ReaderJdomUtil.getAttributeEnum(element, "refresh-policy", RefreshPolity.class));
            n2oWidget.setIcon(ReaderJdomUtil.getAttributeString(element, "icon"));
            n2oWidget.setDetailFieldId(ReaderJdomUtil.getAttributeString(widget, "detail-field-id"));
            n2oWidget.setMasterFieldId(ReaderJdomUtil.getAttributeString(widget, "master-field-id"));
            n2oWidget.setId(ReaderJdomUtil.getAttributeString(element, "id"));
            n2oWidget.setRefreshDependentContainer(ReaderJdomUtil.getAttributeBoolean(element, "refresh-dependent-container"));
        }
        if (n2oWidget == null) {
            return null;
        }
        Element preFilters = element.getChild("pre-filters", element.getNamespace());
        n2oWidget.setPreFilters(PreFilterReaderV1Util.getControlPreFilterListDefinition(preFilters));
        n2oWidget.setCounter(ReaderJdomUtil.getChild(element, element.getNamespace(), "counter", CounterReaderV1.getInstance()));
        return n2oWidget;
    }

    public Class<N2oStandardPage> getElementClass() {
        return N2oStandardPage.class;
    }

    public String getNamespaceUri() {
        return "http://n2oapp.net/framework/config/schema/page-1.0";
    }

    public String getElementName() {
        return "page";
    }
}

