/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.widget.widget3;

import java.util.List;
import net.n2oapp.framework.api.metadata.global.view.action.LabelType;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oAbstractTable;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oRow;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.AbstractColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.DirectionType;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.DynamicColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oSimpleColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import net.n2oapp.framework.config.reader.widget.SwitchReader;
import net.n2oapp.framework.config.reader.widget.widget3.DynamicSwitchReader;
import net.n2oapp.framework.config.reader.widget.widget3.WidgetBaseXmlReaderV3;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractTableXmlReaderV3<T extends N2oAbstractTable>
extends WidgetBaseXmlReaderV3<N2oWidget> {
    protected static final Namespace DEFAULT_CELL_NAMESPACE_URI = Namespace.getNamespace((String)"http://n2oapp.net/framework/config/schema/n2o-cell-1.0");

    protected void getAbstractTableDefinition(Element tableElement, Namespace namespace, N2oAbstractTable n2oTable, NamespaceReaderFactory extensionReaderFactory) {
        Element colorElement;
        Element rowsElement;
        Element sortingsElement;
        this.readRef(tableElement, (N2oWidget)n2oTable);
        Element columnsElement = tableElement.getChild("columns", namespace);
        if (columnsElement != null) {
            n2oTable.setColumns(AbstractTableXmlReaderV3.readColumns(columnsElement, namespace, extensionReaderFactory));
        }
        if ((sortingsElement = tableElement.getChild("sortings", namespace)) != null) {
            List sortings = sortingsElement.getChildren();
            for (Element sorting : sortings) {
                String sortingFieldId = ReaderJdomUtil.getAttributeString(sorting, "sorting-field-id");
                DirectionType direction = ReaderJdomUtil.getAttributeEnum(sorting, "direction", DirectionType.class);
                for (AbstractColumn column : n2oTable.getColumns()) {
                    if (!column.getTextFieldId().equals(sortingFieldId)) continue;
                    column.setSortingDirection(direction);
                }
            }
        }
        if ((rowsElement = tableElement.getChild("rows", namespace)) != null && (colorElement = rowsElement.getChild("color", namespace)) != null) {
            N2oRow rows = new N2oRow();
            rows.setColor(AbstractTableXmlReaderV3.readSwitchCell(colorElement, namespace, "color-field-id"));
            n2oTable.setRows(rows);
        }
        n2oTable.setPagingMode(ReaderJdomUtil.getElementAttributeEnum(tableElement, "paging", "mode", N2oAbstractTable.PagingMode.class));
        n2oTable.setAlwaysShowCount(ReaderJdomUtil.getElementAttributeBoolean(tableElement, "paging", "always-show-count"));
        n2oTable.setHasCheckboxes(ReaderJdomUtil.getElementBoolean(tableElement, "checkboxes"));
        n2oTable.setAutoSelect(ReaderJdomUtil.getElementBoolean(tableElement, "auto-select"));
        this.readWidgetDefinition(tableElement, namespace, (N2oWidget)n2oTable);
    }

    private static N2oSwitch readSwitchCell(Element icon, Namespace namespace, String fieldIdAttributeName) {
        if (icon == null) {
            return null;
        }
        return new SwitchReader(fieldIdAttributeName).read(icon);
    }

    public Class<N2oWidget> getElementClass() {
        return N2oWidget.class;
    }

    public static AbstractColumn[] readColumns(Element element, Namespace namespace, NamespaceReaderFactory extensionReaderFactory) {
        List columns = element.getChildren();
        return (AbstractColumn[])columns.stream().map(columnElement -> {
            boolean isDynamic = columnElement.getName().equals("dynamic-column");
            DynamicColumn column = isDynamic ? new DynamicColumn() : new N2oSimpleColumn();
            String columnFieldId = columnElement.getAttribute("column-field-id").getValue();
            String tooltipFieldId = null;
            Attribute tooltipFieldIdElement = columnElement.getAttribute("tooltip-field-id");
            if (tooltipFieldIdElement != null) {
                tooltipFieldId = tooltipFieldIdElement.getValue();
            }
            String width = null;
            Attribute widthElement = columnElement.getAttribute("width");
            if (widthElement != null) {
                width = widthElement.getValue();
            }
            column.setTextFieldId(columnFieldId);
            column.setTooltipFieldId(tooltipFieldId);
            column.setWidth(width);
            column.setFormat(ReaderJdomUtil.getAttributeString(columnElement, "format"));
            column.setLabelName(ReaderJdomUtil.getAttributeString(columnElement, "name"));
            column.setLabelType(ReaderJdomUtil.getAttributeEnum(columnElement, "type", LabelType.class));
            column.setLabelIcon(ReaderJdomUtil.getAttributeString(columnElement, "icon"));
            column.setVisible(ReaderJdomUtil.getAttributeString(columnElement, "visible"));
            column.setVisibilityCondition(ReaderJdomUtil.getAttributeString(columnElement, "visibility-condition"));
            if (isDynamic) {
                AbstractTableXmlReaderV3.readDynamicColumn(columnElement, (AbstractColumn)column, namespace, extensionReaderFactory);
            } else {
                AbstractTableXmlReaderV3.readSimpleColumn(columnElement, (AbstractColumn)column, namespace, extensionReaderFactory);
            }
            return column;
        }).toArray(AbstractColumn[]::new);
    }

    private static void readSimpleColumn(Element element, AbstractColumn c, Namespace namespace, NamespaceReaderFactory extensionReaderFactory) {
        N2oSimpleColumn column = (N2oSimpleColumn)c;
        if (element.getChildren() != null && element.getChildren().size() > 0) {
            N2oCell cell = (N2oCell)extensionReaderFactory.produce((Element)element.getChildren().get(0), element.getNamespace(), new Namespace[]{DEFAULT_CELL_NAMESPACE_URI}).read((Element)element.getChildren().get(0));
            column.setCell(cell);
        }
    }

    private static void readDynamicColumn(Element element, AbstractColumn c, Namespace namespace, NamespaceReaderFactory extensionReaderFactory) {
        Element aSwitch = element.getChild("switch", namespace);
        if (aSwitch == null) {
            return;
        }
        DynamicColumn column = (DynamicColumn)c;
        column.setN2oSwitch(new DynamicSwitchReader<N2oCell>(extensionReaderFactory, DEFAULT_CELL_NAMESPACE_URI.getURI(), N2oCell.class).read(element));
    }
}

