/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.widget.widget3;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.CssClassAware;
import net.n2oapp.framework.api.metadata.event.action.N2oAbstractAction;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.view.action.LabelType;
import net.n2oapp.framework.api.metadata.global.view.page.GenerateType;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.GroupItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.reader.AbstractFactoredReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.config.reader.tools.CssClassAwareReader;
import net.n2oapp.framework.config.reader.tools.MenuItemConditionReader;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class WidgetBaseXmlReaderV3<E extends N2oWidget>
extends AbstractFactoredReader<E> {
    private static final String DEFAULT_NAMESPACE_URI = "http://n2oapp.net/framework/config/schema/n2o-widget-3.0";
    private static final Namespace DEFAULT_EVENT_NAMESPACE_URI = Namespace.getNamespace((String)"http://n2oapp.net/framework/config/schema/n2o-event-1.0");

    public void setReaderFactory(NamespaceReaderFactory readerFactory) {
        super.setReaderFactory(readerFactory);
    }

    protected void readWidgetDefinition(Element widget, Namespace namespace, N2oWidget n2oWidget) {
        n2oWidget.setMasterFieldId(ReaderJdomUtil.getAttributeString(widget, "master-field-id"));
        n2oWidget.setDetailFieldId(ReaderJdomUtil.getAttributeString(widget, "detail-field-id"));
        n2oWidget.setName(ReaderJdomUtil.getElementString(widget, "name"));
        n2oWidget.setSrc(ReaderJdomUtil.getAttributeString(widget, "src"));
        n2oWidget.setCustomize(ReaderJdomUtil.getAttributeString(widget, "customize"));
        n2oWidget.setQueryId(ReaderJdomUtil.getElementString(widget, "query-id"));
        n2oWidget.setDefaultValuesQueryId(ReaderJdomUtil.getElementString(widget, "default-values-query-id"));
        n2oWidget.setObjectId(ReaderJdomUtil.getElementString(widget, "object-id"));
        n2oWidget.setSize(ReaderJdomUtil.getElementInteger(widget, "size"));
        n2oWidget.setBorder(ReaderJdomUtil.getElementBoolean(widget, "border"));
        n2oWidget.setNamespaceUri(namespace.getURI());
        CssClassAwareReader.getInstance().read((CssClassAware)n2oWidget, widget);
        this.initToolbars(widget, n2oWidget, namespace);
    }

    protected void readRef(Element element, N2oWidget widget) {
        this.readWidgetDefinition(element, element.getNamespace(), widget);
        String refId = ReaderJdomUtil.getAttributeString(element, "ref-id");
        if (refId != null) {
            widget.setRefId(refId);
            widget.setId(refId);
        }
    }

    public String getNamespaceUri() {
        return DEFAULT_NAMESPACE_URI;
    }

    private void initToolbars(Element widget, N2oWidget n2oWidget, Namespace namespace) {
        Element actionMenuElement = widget.getChild("action-menu", namespace);
        if (actionMenuElement == null) {
            return;
        }
        ArrayList<N2oToolbar> toolbars = new ArrayList<N2oToolbar>();
        N2oToolbar defaultToolbar = new N2oToolbar();
        Boolean inheritDefault = ReaderJdomUtil.getAttributeBoolean(actionMenuElement, "inherit-default");
        if (inheritDefault != null && inheritDefault.booleanValue()) {
            String[] generate = new String[]{GenerateType.crud.name()};
            defaultToolbar.setGenerate(generate);
        }
        List popupMenus = actionMenuElement.getChildren();
        ArrayList<Object> defaultToolbarItems = new ArrayList<Object>();
        for (Element popupMenu : popupMenus) {
            if (popupMenu.getName().equals("menu-item")) {
                N2oButton button = new N2oButton();
                this.readMenuItem(popupMenu, button, namespace);
                defaultToolbarItems.add(button);
                continue;
            }
            if (popupMenu.getName().equals("sub-menu")) {
                N2oSubmenu mi = this.getSubMenu(popupMenu, namespace);
                defaultToolbarItems.add(mi);
                continue;
            }
            if (!popupMenu.getName().equals("group")) continue;
            String place = ReaderJdomUtil.getAttributeString(popupMenu, "place");
            if (place == null) {
                N2oGroup group = new N2oGroup();
                this.readGroup(popupMenu, group, namespace);
                defaultToolbarItems.add(group);
                continue;
            }
            N2oToolbar toolbar = new N2oToolbar();
            toolbar.setPlace(place);
            N2oGroup group = new N2oGroup();
            this.readGroup(popupMenu, group, namespace);
            toolbar.setItems(new ToolbarItem[]{group});
            toolbars.add(toolbar);
        }
        if (!defaultToolbarItems.isEmpty()) {
            ToolbarItem[] toolbarItems = new ToolbarItem[defaultToolbarItems.size()];
            defaultToolbar.setItems(defaultToolbarItems.toArray(toolbarItems));
            toolbars.add(0, defaultToolbar);
        }
        N2oToolbar[] toolbarArray = new N2oToolbar[toolbars.size()];
        n2oWidget.setToolbars(toolbars.toArray(toolbarArray));
    }

    private void readGroup(Element groupElement, N2oGroup group, Namespace namespace) {
        List popupMenus = groupElement.getChildren();
        GroupItem[] items = new GroupItem[popupMenus.size()];
        int i = 0;
        for (Element popupMenu : popupMenus) {
            if (popupMenu.getName().equals("menu-item")) {
                N2oButton button = new N2oButton();
                this.readMenuItem(popupMenu, button, namespace);
                items[i] = button;
            } else if (popupMenu.getName().equals("sub-menu")) {
                N2oSubmenu mi = this.getSubMenu(popupMenu, namespace);
                items[i] = mi;
            }
            ++i;
        }
        group.setItems(items);
    }

    private void readMenuItem(Element popupMenu, N2oButton menuItem, Namespace namespace) {
        Boolean context;
        menuItem.setId(ReaderJdomUtil.getAttributeString(popupMenu, "id"));
        menuItem.setLabel(ReaderJdomUtil.getAttributeString(popupMenu, "label"));
        menuItem.setType(ReaderJdomUtil.getAttributeEnum(popupMenu, "type", LabelType.class));
        menuItem.setIcon(ReaderJdomUtil.getAttributeString(popupMenu, "icon"));
        menuItem.setColor(ReaderJdomUtil.getAttributeString(popupMenu, "color"));
        menuItem.setDescription(ReaderJdomUtil.getElementString(popupMenu, "description"));
        menuItem.setVisible(ReaderJdomUtil.getAttributeString(popupMenu, "visible"));
        menuItem.setValidate(ReaderJdomUtil.getAttributeBoolean(popupMenu, "validate"));
        Element eventElement = popupMenu.getChild("event", namespace);
        if (eventElement != null && eventElement.getChildren() != null && !eventElement.getChildren().isEmpty()) {
            N2oAbstractAction action = (N2oAbstractAction)this.readerFactory.produce((Element)eventElement.getChildren().get(0), popupMenu.getNamespace(), new Namespace[]{DEFAULT_EVENT_NAMESPACE_URI}).read((Element)eventElement.getChildren().get(0));
            menuItem.setAction((N2oAction)action);
        }
        if ((context = ReaderJdomUtil.getAttributeBoolean(popupMenu, "context")) == null || context.booleanValue()) {
            menuItem.setModel(ReduxModel.RESOLVE);
        } else {
            menuItem.setModel(ReduxModel.FILTER);
        }
        menuItem.setEnablingConditions(ReaderJdomUtil.getChildren(popupMenu, "conditions", "enabling-condition", MenuItemConditionReader.getInstance()));
        menuItem.setVisibilityConditions(ReaderJdomUtil.getChildren(popupMenu, "conditions", "visibility-condition", MenuItemConditionReader.getInstance()));
    }

    private N2oSubmenu getSubMenu(Element subMenuElement, Namespace namespace) {
        if (subMenuElement == null) {
            return null;
        }
        List popupMenus = subMenuElement.getChildren();
        N2oSubmenu subMenu = new N2oSubmenu();
        subMenu.setId(ReaderJdomUtil.getAttributeString(subMenuElement, "id"));
        subMenu.setLabel(ReaderJdomUtil.getAttributeString(subMenuElement, "label"));
        subMenu.setType(ReaderJdomUtil.getAttributeEnum(subMenuElement, "type", LabelType.class));
        subMenu.setIcon(ReaderJdomUtil.getAttributeString(subMenuElement, "icon"));
        subMenu.setColor(ReaderJdomUtil.getAttributeString(subMenuElement, "color"));
        subMenu.setDescription(ReaderJdomUtil.getElementString(subMenuElement, "description"));
        N2oButton[] subMenuItems = new N2oButton[popupMenus.size()];
        int i = 0;
        for (Element subPopupMenu : popupMenus) {
            N2oButton menuItem = new N2oButton();
            this.readMenuItem(subPopupMenu, menuItem, namespace);
            subMenuItems[i] = menuItem;
            ++i;
        }
        subMenu.setMenuItems(subMenuItems);
        return subMenu;
    }
}

