/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.audit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.n2oapp.framework.config.register.audit.model.N2oConfigConflict;

public class N2oConfigConflictParser {
    public static final String REGEX_LINE_END = "(\\r\\n|\\r|\\n|\\n\\r)";
    private static final String DEFAULT_LINE_END = "\n";
    public static final String START_LINE_CONFLICT = "<<<<<<< HEAD";
    public static final String MIDDLE_LINE_CONFLICT = "=======";
    public static final String FINISH_LINE_CONFLICT = ">>>>>>>";

    public static N2oConfigConflict restoreContentsByConflict(N2oConfigConflict configConflict) {
        String conflictContent = configConflict.getConflictContent();
        if (conflictContent == null || "".equals(conflictContent)) {
            return configConflict;
        }
        Iterator<String> conflictIterator = N2oConfigConflictParser.toList(conflictContent).iterator();
        configConflict.setParentContent(N2oConfigConflictParser.getParent(conflictIterator));
        return configConflict;
    }

    private static List<String> toList(String conflictContent) {
        return Arrays.asList(conflictContent.split(REGEX_LINE_END));
    }

    private static String getParent(Iterator<String> i) {
        ArrayList<String> parents = new ArrayList<String>();
        while (i.hasNext()) {
            String s = i.next();
            if (s.contains(START_LINE_CONFLICT)) {
                String conflict;
                while (i.hasNext() && !(conflict = i.next()).contains(MIDDLE_LINE_CONFLICT)) {
                }
                while (i.hasNext() && !(conflict = i.next()).contains(FINISH_LINE_CONFLICT)) {
                }
                parents.add("");
                continue;
            }
            parents.add(s);
        }
        return N2oConfigConflictParser.convertToString(parents);
    }

    private static String convertToString(List<String> origins) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < origins.size() - 1; ++i) {
            str.append(origins.get(i)).append(DEFAULT_LINE_END);
        }
        str.append(origins.get(origins.size() - 1));
        return str.toString();
    }
}

