/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective.reader;

import java.util.stream.Stream;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.reader.ElementReaderFactory;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.pack.ReadersBuilder;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.selective.SelectiveMetadataLoader;
import net.n2oapp.framework.config.selective.SelectiveUtil;
import net.n2oapp.framework.config.selective.reader.ReaderFactoryByMap;

public class SelectiveReader
extends SelectiveMetadataLoader
implements ReadersBuilder<SelectiveReader> {
    public SelectiveReader() {
        super(new ReaderFactoryByMap());
        ReaderJdomUtil.clearTextProcessing();
    }

    public SelectiveReader addReader(NamespaceReader<? extends NamespaceUriAware> reader) {
        this.add(reader);
        return this;
    }

    public SelectiveReader addReader(NamespaceIO<? extends NamespaceUriAware> io) {
        this.add(io);
        return this;
    }

    public <T> T readByPath(String path) {
        return (T)SelectiveUtil.readByPath(PathUtil.convertPathToClasspathUri(path), this.readerFactory);
    }

    public <T> T readByURI(String uri) {
        return (T)SelectiveUtil.readByPath(uri, this.readerFactory);
    }

    public <T> T read(String source) {
        return (T)SelectiveUtil.read(source, (ElementReaderFactory)this.readerFactory);
    }

    @SafeVarargs
    public final SelectiveReader readers(NamespaceReader<? extends NamespaceUriAware> ... readers) {
        Stream.of(readers).forEach(this::addReader);
        return this;
    }

    @SafeVarargs
    public final SelectiveReader ios(NamespaceIO<? extends NamespaceUriAware> ... ios) {
        Stream.of(ios).forEach(this::addReader);
        return this;
    }
}

