/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.groovy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.n2oapp.framework.api.exception.N2oException;

public class GroovyScriptProcessor {
    private static final ScriptEngineManager factory = new ScriptEngineManager();
    private static volatile ScriptEngine scriptEngine;

    public static <T> Set<T> collectFromScript(String src, Class<T> clazz) {
        Bindings bindings = GroovyScriptProcessor.getScriptEngine().createBindings();
        Object result = GroovyScriptProcessor.runScript(src, bindings);
        HashSet collection = new HashSet();
        GroovyScriptProcessor.collect(collection, result, clazz);
        for (Object value : bindings.values()) {
            GroovyScriptProcessor.collect(collection, value, clazz);
        }
        return collection;
    }

    public static <T> T getFromScript(String src, Class<T> clazz) {
        Set<T> result = GroovyScriptProcessor.collectFromScript(src, clazz);
        if (result.isEmpty()) {
            throw new IllegalStateException(String.format("script does not return any object by class: '%s'", clazz));
        }
        if (result.size() > 1) {
            throw new IllegalStateException(String.format("script returned more than one object by class: '%s'", clazz));
        }
        return result.iterator().next();
    }

    private static Object runScript(String script, Bindings bindings) {
        try {
            return GroovyScriptProcessor.getScriptEngine().eval(script, bindings);
        }
        catch (ScriptException e) {
            throw new N2oException((Throwable)e);
        }
    }

    private static <T> void collect(Set<T> collection, Object object, Class<T> clazz) {
        if (object == null) {
            return;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            collection.add(object);
        } else if (object instanceof Collection) {
            for (Object item : (Collection)object) {
                GroovyScriptProcessor.collect(collection, item, clazz);
            }
        }
    }

    private static ScriptEngine getScriptEngine() {
        if (scriptEngine == null) {
            try {
                GroovyScriptProcessor.createScriptEngine();
            }
            catch (ScriptException e) {
                throw new IllegalStateException(e);
            }
        }
        return scriptEngine;
    }

    private static synchronized void createScriptEngine() throws ScriptException {
        if (scriptEngine == null && (scriptEngine = factory.getEngineByName("Groovy")) == null) {
            throw new IllegalStateException("Need groovy-all dependency!");
        }
    }
}

