/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.application;

import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.application.Application;
import net.n2oapp.framework.api.metadata.application.Sidebar;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.header.Header;
import net.n2oapp.framework.api.metadata.header.HeaderItem;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.config.metadata.compile.BaseMetadataBinder;
import org.springframework.stereotype.Component;

@Component
public class ApplicationBinder
implements BaseMetadataBinder<Application> {
    public Class<? extends Compiled> getCompiledClass() {
        return Application.class;
    }

    public Application bind(Application compiled, BindProcessor p) {
        this.bindHeader(p, compiled.getHeader());
        this.bindSidebar(p, compiled.getSidebar());
        return compiled;
    }

    private void bindHeader(BindProcessor p, Header header) {
        if (header != null) {
            this.bindMenu(header.getMenu(), p);
            this.bindMenu(header.getExtraMenu(), p);
        }
    }

    private void bindSidebar(BindProcessor p, Sidebar sidebar) {
        if (sidebar != null) {
            this.bindMenu(sidebar.getMenu(), p);
            this.bindMenu(sidebar.getExtraMenu(), p);
        }
    }

    private void bindMenu(SimpleMenu menu, BindProcessor p) {
        if (menu != null && menu.getItems() != null) {
            menu.getItems().forEach(i -> this.resolveItem((HeaderItem)i, p));
        }
    }

    private void resolveItem(HeaderItem item, BindProcessor p) {
        item.setTitle(p.resolveText(item.getTitle()));
        item.setBadge(p.resolve(item.getBadge()));
        item.setBadgeColor((String)p.resolve(item.getBadgeColor(), String.class));
        item.setImageSrc((String)p.resolve(item.getImageSrc(), String.class));
        if (item.getSubItems() != null) {
            item.getSubItems().forEach(i -> this.resolveItem((HeaderItem)i, p));
        }
    }
}

