/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.PreFiltersAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;
import net.n2oapp.framework.api.metadata.meta.control.ControlDependency;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.control.ListControl;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.util.FieldCompileUtil;
import net.n2oapp.framework.config.util.N2oClientDataProviderUtil;

public abstract class ListControlCompiler<T extends ListControl, S extends N2oListField>
extends StandardFieldCompiler<T, S> {
    protected StandardField<T> compileListControl(T listControl, S source, CompileContext<?, ?> context, CompileProcessor p) {
        listControl.setFormat(p.resolveJS(source.getFormat()));
        listControl.setLabelFieldId((String)p.cast((Object)p.resolveJS(source.getLabelFieldId()), (Object)"name", new Object[0]));
        listControl.setSortFieldId((String)p.cast((Object)source.getSortFieldId(), (Object)listControl.getLabelFieldId(), new Object[0]));
        listControl.setValueFieldId((String)p.cast((Object)p.resolveJS(source.getValueFieldId()), (Object)"id", new Object[0]));
        listControl.setIconFieldId(p.resolveJS(source.getIconFieldId()));
        listControl.setBadgeFieldId(p.resolveJS(source.getBadgeFieldId()));
        listControl.setBadgeColorFieldId(p.resolveJS(source.getBadgeColorFieldId()));
        listControl.setImageFieldId(p.resolveJS(source.getImageFieldId()));
        listControl.setGroupFieldId(p.resolveJS(source.getGroupFieldId()));
        listControl.setHasSearch(source.getSearch());
        listControl.setStatusFieldId(source.getStatusFieldId());
        if (source.getQueryId() != null) {
            this.initDataProvider(listControl, (N2oListField)source, context, p);
        } else if (source.getOptions() != null) {
            ArrayList<DataSet> list = new ArrayList<DataSet>();
            for (Map option : source.getOptions()) {
                DataSet dataItem = new DataSet();
                option.forEach((f, v) -> dataItem.put(f, p.resolve(v)));
                list.add(dataItem);
            }
            listControl.setData(list);
        }
        listControl.setValueFieldId((String)p.cast((Object)p.resolveJS(listControl.getValueFieldId()), (Object)"id", new Object[0]));
        listControl.setLabelFieldId((String)p.cast((Object)p.resolveJS(listControl.getLabelFieldId()), (Object)"name", new Object[0]));
        listControl.setCaching(source.getCache());
        listControl.setEnabledFieldId(source.getEnabledFieldId());
        this.initSubModel(source, listControl.getData(), (SubModelsScope)p.getScope(SubModelsScope.class));
        return this.compileStandardField(listControl, source, context, p);
    }

    @Override
    protected Object compileDefValues(S source, CompileProcessor p) {
        if (source.getDefValue() == null) {
            return null;
        }
        DefaultValues values = new DefaultValues();
        values.setValues(new HashMap());
        source.getDefValue().forEach((f, v) -> values.getValues().put(f, p.resolve(v)));
        return source.isSingle() ? values : Collections.singletonList(values);
    }

    @Override
    protected void compileParams(StandardField<T> control, S source, WidgetParamScope paramScope, CompileProcessor p) {
        if (source.getParam() == null) {
            return;
        }
        String id = control.getId() + ".id";
        ModelsScope modelsScope = (ModelsScope)p.getScope(ModelsScope.class);
        if (modelsScope != null) {
            ModelLink onSet = this.compileLinkOnSet(control, source, modelsScope);
            ReduxAction onGet = Redux.dispatchUpdateModel(modelsScope.getWidgetId(), modelsScope.getModel(), id, Placeholders.colon((String)source.getParam()));
            paramScope.addQueryMapping(source.getParam(), onGet, (BindLink)onSet);
        }
    }

    protected ModelLink compileLinkOnSet(StandardField<T> control, S source, ModelsScope modelsScope) {
        ModelLink onSet = new ModelLink(modelsScope.getModel(), modelsScope.getWidgetId(), control.getId());
        onSet.setParam(source.getParam());
        onSet.setSubModelQuery(this.createSubModel((N2oListField)source, ((ListControl)control.getControl()).getData()));
        onSet.setValue((Object)"`id`");
        return onSet;
    }

    protected StandardField<T> compileFetchDependencies(StandardField<T> field, S source, CompileProcessor p) {
        if (source.getPreFilters() != null && field.getDependencies().stream().noneMatch(d -> d.getType() == ValidationType.fetch)) {
            HashSet<String> setOn = new HashSet<String>();
            for (N2oPreFilter filter : source.getPreFilters()) {
                if (!StringUtils.hasLink((String)filter.getValue())) continue;
                String resolveOnJS = p.resolveJS(filter.getValue());
                resolveOnJS = resolveOnJS.substring(1, resolveOnJS.length() - 1);
                setOn.add(resolveOnJS);
            }
            if (!setOn.isEmpty()) {
                ControlDependency fetchCD = new ControlDependency();
                fetchCD.setType(ValidationType.fetch);
                fetchCD.setOn(new ArrayList(setOn));
                field.addDependency(fetchCD);
            }
        }
        return field;
    }

    private void initSubModel(S source, List<Map<String, Object>> data, SubModelsScope scope) {
        if (scope == null) {
            return;
        }
        if (source.getQueryId() != null || data != null) {
            scope.add(this.createSubModel((N2oListField)source, data));
        }
    }

    protected SubModelQuery createSubModel(N2oListField item, List<Map<String, Object>> data) {
        return new SubModelQuery(item.getId(), item.getQueryId(), item.getValueFieldId() != null ? item.getValueFieldId() : "id", item.getLabelFieldId() != null ? item.getLabelFieldId() : "name", !item.isSingle(), data);
    }

    private void initDataProvider(T listControl, N2oListField source, CompileContext<?, ?> context, CompileProcessor p) {
        N2oClientDataProvider dataProvider = N2oClientDataProviderUtil.initFromField(source.getPreFilters(), source.getQueryId(), p);
        source.addDependencies(FieldCompileUtil.getResetOnChangeDependency((PreFiltersAware)source));
        QueryContext queryContext = new QueryContext(source.getQueryId());
        CompiledQuery query = (CompiledQuery)p.getCompiled((CompileContext)queryContext);
        if (listControl.getHasSearch() != null && listControl.getHasSearch().booleanValue()) {
            String searchFilterId = (String)p.cast((Object)source.getSearchFilterId(), (Object)listControl.getLabelFieldId(), new Object[0]);
            if (query.getFilterIdToParamMap().containsKey(searchFilterId)) {
                dataProvider.setQuickSearchParam((String)query.getFilterIdToParamMap().get(searchFilterId));
            } else if (searchFilterId != null && listControl.getHasSearch().booleanValue()) {
                throw new N2oException(String.format("For search field id [%s] is necessary this filter-id in query [%s]", searchFilterId, query.getId()));
            }
        }
        listControl.setDataProvider(ClientDataProviderUtil.compile(dataProvider, context, p));
    }
}

